/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.context;

import cn.dev33.satoken.fun.SaRetGenericFunction;
import cn.dev33.satoken.reactor.context.SaReactorSyncHolder;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class SaReactorHolder {
    public static final String EXCHANGE_KEY = "SA_REACTOR_EXCHANGE_KEY";
    public static final String CHAIN_KEY = "SA_REACTOR__CHAIN_KEY";

    public static Context setContext(Context ctx, ServerWebExchange exchange, WebFilterChain chain) {
        return ctx.put((Object)EXCHANGE_KEY, (Object)exchange).put((Object)CHAIN_KEY, (Object)chain);
    }

    public static ServerWebExchange getExchange(ContextView ctx) {
        return (ServerWebExchange)ctx.get((Object)EXCHANGE_KEY);
    }

    public static WebFilterChain getChain(ContextView ctx) {
        return (WebFilterChain)ctx.get((Object)CHAIN_KEY);
    }

    public static Mono<ServerWebExchange> getMonoExchange() {
        return Mono.deferContextual(ctx -> Mono.just((Object)SaReactorHolder.getExchange(ctx)));
    }

    public static <R> Mono<R> sync(SaRetGenericFunction<R> fun) {
        return Mono.deferContextual(ctx -> {
            try {
                SaReactorSyncHolder.setContext((ServerWebExchange)ctx.get((Object)EXCHANGE_KEY));
                Mono mono = Mono.just((Object)fun.run());
                return mono;
            }
            finally {
                SaReactorSyncHolder.clearContext();
            }
        });
    }
}

