/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.preprocess;

import ai.djl.modality.nlp.preprocess.TextProcessor;
import java.util.ArrayList;
import java.util.List;

public class TextTerminator
implements TextProcessor {
    private static final String DEFAULT_EOS_TOKEN = "<eos>";
    private static final String DEFAULT_BOS_TOKEN = "<bos>";
    private boolean addBosToken;
    private boolean addEosToken;
    private String eosToken;
    private String bosToken;

    public TextTerminator() {
        this(true, true);
    }

    public TextTerminator(boolean addBosToken, boolean addEosToken) {
        this.addBosToken = addBosToken;
        this.addEosToken = addEosToken;
        this.bosToken = DEFAULT_BOS_TOKEN;
        this.eosToken = DEFAULT_EOS_TOKEN;
    }

    public TextTerminator(boolean addBosToken, boolean addEosToken, String bosToken, String eosToken) {
        this.addBosToken = addBosToken;
        this.addEosToken = addEosToken;
        this.bosToken = bosToken;
        this.eosToken = eosToken;
    }

    @Override
    public List<String> preprocess(List<String> tokens) {
        ArrayList<String> list = new ArrayList<String>(tokens.size() + 2);
        if (this.addBosToken) {
            list.add(this.bosToken);
        }
        list.addAll(tokens);
        if (this.addEosToken) {
            list.add(this.eosToken);
        }
        return list;
    }
}

