/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.sdk.invoice;

import com.suwell.rpc.mgr.model.api.Signature;
import com.suwell.sdk.invoice.Watermark;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Extend {
    private static final String DF = "yyyy-MM-dd";
    private List<EleSeal> eleSeals;
    private Set<ResultType> resultType;
    private Set<Watermark> imageMark;
    private Set<Watermark> textMark;
    private Envelope envelope;
    private String method;

    public List<EleSeal> getEleSeals() {
        return this.eleSeals;
    }

    public Extend setMethod(String method) {
        this.method = method;
        return this;
    }

    public Extend setEleSeals(EleSeal es) {
        if (this.eleSeals == null) {
            this.eleSeals = new ArrayList<EleSeal>();
        }
        if (es != null) {
            this.eleSeals.add(es);
        }
        return this;
    }

    public Set<ResultType> getResultType() {
        return this.resultType;
    }

    public Extend setResultType(ResultType ... resultType) {
        if (this.resultType == null) {
            this.resultType = new HashSet<ResultType>();
        }
        if (resultType != null && resultType.length > 0) {
            for (ResultType rt : resultType) {
                this.resultType.add(rt);
            }
        }
        return this;
    }

    public Set<Watermark> getImageMark() {
        return this.imageMark;
    }

    public Extend setImageMark(Watermark.ImageMark imageMark) {
        if (this.imageMark == null) {
            this.imageMark = new HashSet<Watermark>();
        }
        this.imageMark.add(imageMark);
        return this;
    }

    public Set<Watermark> getTextMark() {
        return this.textMark;
    }

    public Extend setTextMark(Watermark.TextMark textMark) {
        if (this.textMark == null) {
            this.textMark = new HashSet<Watermark>();
        }
        this.textMark.add(textMark);
        return this;
    }

    public static ResultType createPDFResultType() {
        ResultType ort = new ResultType();
        ort.format = "pdf";
        return ort;
    }

    public static ResultType createOFDResultType() {
        ResultType ort = new ResultType();
        ort.format = "ofd";
        return ort;
    }

    public static ResultType createImageResultType(ImageType it) {
        ResultType ort = new ResultType();
        ort.format = it.name();
        return ort;
    }

    public static ResultType createImageResultType(ImageType it, int dpi) {
        ResultType ort = new ResultType();
        ort.format = it.name();
        ort.dpi = dpi;
        return ort;
    }

    public static Watermark.ImageMark createImageMark(String base64, float x, float y, float w, float h, int ... index) {
        Watermark.ImageMark wim = new Watermark.ImageMark();
        wim.setValue(base64);
        wim.setX(x);
        wim.setY(y);
        wim.setW(w);
        wim.setH(h);
        wim.setPages(index);
        return wim;
    }

    public static Watermark.TextMark createTextMark(String value, String fontName, float fontSize, float x, float y, int ... index) {
        Watermark.TextMark wt = new Watermark.TextMark();
        wt.setValue(value);
        wt.setX(x);
        wt.setY(y);
        wt.setFontName(fontName);
        wt.setFontSize(fontSize);
        wt.setPages(index);
        return wt;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public static class Envelope {
        private String provider = "Suwell";
        private String password;
        private String pwdType = "Custom";
        private String start;
        private String end;

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPwdType() {
            return this.pwdType;
        }

        public void setPwdType(String pwdType) {
            this.pwdType = pwdType;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public void setStart(Date start) {
            this.start = Envelope.adjust(start);
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public void setEnd(Date end) {
            this.end = Envelope.adjust(end);
        }

        public static String adjust(Date date) {
            if (date != null) {
                SimpleDateFormat df = new SimpleDateFormat(Extend.DF);
                return df.format(date);
            }
            return null;
        }
    }

    public static enum ImageType {
        jpg,
        png,
        tif,
        bmp,
        html;

    }

    public static class ResultType {
        String format;
        int dpi;
        float imageWidth;

        ResultType() {
        }

        public String getFormat() {
            return this.format;
        }

        public int getDpi() {
            return this.dpi;
        }

        public float getImageWidth() {
            return this.imageWidth;
        }
    }

    public static class EleSeal {
        private String name;
        private String sealID;
        private String password;
        private String type = "Normal";
        private float x;
        private float y;
        private float w;
        private float h;
        private int index;
        private boolean sign;
        private Map<String, String> extend;

        public Map<String, String> getExtend() {
            return this.extend;
        }

        public EleSeal addExtendParam(Signature.SignatureExtendKey signatureExtendKey, String v) {
            if (this.extend == null) {
                this.extend = new HashMap<String, String>();
            }
            this.extend.put(signatureExtendKey.name(), v);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public EleSeal setName(String name) {
            this.name = name;
            return this;
        }

        public String getSealID() {
            return this.sealID;
        }

        public EleSeal setSealID(String sealID) {
            this.sealID = sealID;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public EleSeal setPassword(String password) {
            this.password = password;
            return this;
        }

        @Deprecated
        public EleSeal setLocation(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public EleSeal setLocation(float x, float y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public EleSeal setSign(boolean sign) {
            this.sign = sign;
            return this;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getW() {
            return this.w;
        }

        public float getH() {
            return this.h;
        }

        public String getType() {
            return this.type;
        }

        public EleSeal setType(Type type) {
            this.type = type.name();
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public static enum Type {
            Last,
            First,
            All,
            Check,
            Normal;

        }
    }
}

