/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.rpc.mgr;

import com.suwell.rpc.mgr.ACIS;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHelper
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(WebHelper.class);
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_SERVER_NAME = "X-Server-Name";
    public static final String HEADER_SERVER_PATH = "X-Server-Path";
    private final int count;
    private final String url;
    private CloseableHttpClient client;
    private ThreadLocal<Header[]> headers;
    private volatile boolean closed = false;
    public static final ResponseHandler<Void> RH_IGNORE = new ResponseHandler<Void>(){

        public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            return null;
        }
    };
    public static final ResponseHandler<String> RH_TEXT = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            }
            HttpEntity entity = response.getEntity();
            throw new IOException("Unexpected response status: " + status + "\n response: " + entity != null ? EntityUtils.toString((HttpEntity)entity) : "null");
        }
    };

    public WebHelper(String urlBase, int maxActiveCount) {
        this.count = maxActiveCount;
        String path = urlBase;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.url = path;
        this.init();
    }

    private void init() {
        this.headers = new ThreadLocal();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(Math.max(500, this.count * 2));
        cm.setDefaultMaxPerRoute(50);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public String url() {
        return this.url;
    }

    /*
     * Loose catch block
     */
    public <T> T request(HttpRequestBase req, ResponseHandler<T> handler) throws IOException {
        if (this.closed) {
            throw new IOException("Connection pool is closed");
        }
        try {
            Object object;
            log.debug("Request...");
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)req);
            try {
                this.headers.set(response.getAllHeaders());
                Object result = null;
                if (handler != null) {
                    result = handler.handleResponse((HttpResponse)response);
                }
                EntityUtils.consume((HttpEntity)response.getEntity());
                object = result;
            }
            catch (ClientProtocolException t) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (Exception t2) {
                    log.warn("Error consuming content after an exception.", (Throwable)t2);
                }
                throw t;
            }
            finally {
                response.close();
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            req.releaseConnection();
        }
    }

    public Response request(HttpRequestBase req) throws IOException {
        if (this.closed) {
            throw new IOException("Connection pool is closed");
        }
        log.debug("Request...");
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)req);
        this.headers.set(response.getAllHeaders());
        return new Response(req, response);
    }

    public String header(String name) {
        Header[] hs = this.headers.get();
        if (hs != null && name != null) {
            for (Header header : hs) {
                if (!header.getName().equalsIgnoreCase(name)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    private void shutdown() {
        this.closed = true;
        try {
            this.client.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public final class Response
    implements Closeable {
        private final HttpRequestBase request;
        private final CloseableHttpResponse response;
        private HttpEntity entity;
        private volatile boolean closed;

        Response(HttpRequestBase request, CloseableHttpResponse response) {
            this.request = request;
            this.response = response;
        }

        public HttpRequestBase getRequest() {
            return this.request;
        }

        public CloseableHttpResponse getResponse() {
            return this.response;
        }

        public int status() {
            return this.response.getStatusLine().getStatusCode();
        }

        private HttpEntity getEntity() {
            if (this.entity == null) {
                this.entity = this.getResponse().getEntity();
            }
            return this.entity;
        }

        public String toText() throws IOException {
            try {
                String string = EntityUtils.toString((HttpEntity)this.getEntity());
                return string;
            }
            finally {
                this.close(false);
            }
        }

        public ACIS toStream() throws IOException {
            HttpEntity entity = this.getEntity();
            if (entity == null) {
                throw new IOException("Response entity is empty");
            }
            return new ACIS(entity.getContent()){

                @Override
                protected void afterClose() {
                    Response.this.close(true);
                }
            };
        }

        private void close(boolean inQueue) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                EntityUtils.consume((HttpEntity)this.getEntity());
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    this.response.close();
                }
                catch (Exception exception) {}
                try {
                    this.request.releaseConnection();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void close() {
            this.close(true);
        }
    }
}

