/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.jm;

import com.suwell.rpc.mgr.icbc.InParams;
import com.suwell.rpc.mgr.icbc.SuwellOfdFileUtils;
import com.suwell.sdk.invoice.Extend;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;

public class Run
extends AbstractJavaSamplerClient {
    private static final int METHOD_CREATE = 0;
    private static final int METHOD_COLLECT_CREATE = 1;
    private static final int METHOD_TRANSFER = 2;
    private static final int METHOD_SEAL = 3;
    private static final int METHOD_SIGN = 4;
    private static final int METHOD_ENVELOPE = 5;
    private int gm;

    public Arguments getDefaultParameters() {
        Arguments as = new Arguments();
        as.addArgument("ip", "http://127.0.0.1:8090");
        as.addArgument("maxLockCount", "30");
        as.addArgument("method", "create");
        as.addArgument("template", "\u7535\u5b50\u56de\u5355");
        as.addArgument("output", "Output");
        as.addArgument("collectCount", "500");
        return as;
    }

    public void setupTest(JavaSamplerContext context) {
        String ip = context.getParameter("ip");
        String max = context.getParameter("maxLockCount");
        try {
            SuwellOfdFileUtils.init(new URL(ip), Integer.parseInt(max));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String method = context.getParameter("method");
        if ("create".equals(method)) {
            this.gm = 0;
        } else if ("batchCollectCreate".equals(method)) {
            this.gm = 1;
        } else if ("transfer".equals(method)) {
            this.gm = 2;
        } else if ("sign".equals(method)) {
            this.gm = 4;
        } else if ("seal".equals(method)) {
            this.gm = 3;
        } else if ("envelope".equals(method)) {
            this.gm = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult runTest(JavaSamplerContext context) {
        String tpl = context.getParameter("template");
        String output = context.getParameter("output");
        SampleResult sr = new SampleResult();
        try {
            sr.sampleStart();
            switch (this.gm) {
                case 0: {
                    HashMap<String, Object> varMap = new HashMap<String, Object>();
                    Run.pushVarMap4Ebill(varMap);
                    InParams inParams = new InParams().addDatas(varMap).setTplId(tpl).setFormat(InParams.Type.ofd);
                    SuwellOfdFileUtils.create(inParams, output);
                    sr.setResponseData("\u6267\u884ccreate\u5b8c\u6bd5", "UTF-8");
                    break;
                }
                case 1: {
                    String cc = context.getParameter("collectCount");
                    HashMap<String, Object> varMap = new HashMap<String, Object>();
                    Run.pushVarMap4Ebill(varMap);
                    InParams inParams1 = new InParams().setTplId(tpl).setFormat(InParams.Type.ofd);
                    for (int i = 0; i < Integer.parseInt(cc); ++i) {
                        inParams1.addDatas(varMap);
                    }
                    SuwellOfdFileUtils.create(inParams1, output);
                    sr.setResponseData("\u6267\u884cbatchCollectCreate\u5b8c\u6bd5", "UTF-8");
                    break;
                }
                case 2: {
                    SuwellOfdFileUtils.transfer(tpl, output);
                    sr.setResponseData("\u6267\u884ctransfer\u5b8c\u6bd5", "UTF-8");
                    break;
                }
                case 3: {
                    Extend.EleSeal ees = new Extend.EleSeal();
                    ees.setName("Suwell_SDK").setPassword("123456").setSealID("101").setLocation(123.04f, 184.89f, 26.0f, 26.0f).setType(Extend.EleSeal.Type.All);
                    SuwellOfdFileUtils.ofdSealAndEncrypt(tpl, output, null, ees);
                    sr.setResponseData("\u6267\u884cseal\u5b8c\u6bd5", "UTF-8");
                    break;
                }
                case 4: {
                    Extend.EleSeal ees = new Extend.EleSeal();
                    ees.setName("Suwell_SDK").setPassword("123456").setSealID("9a6fe709143103ff").setSign(true);
                    SuwellOfdFileUtils.ofdSealAndEncrypt(tpl, output, null, ees);
                    sr.setResponseData("\u6267\u884csign\u5b8c\u6bd5", "UTF-8");
                    break;
                }
                case 5: {
                    Extend.Envelope envelope = new Extend.Envelope();
                    envelope.setPassword("123456");
                    envelope.setStart(new Date());
                    envelope.setEnd(new Date(System.currentTimeMillis() + 10000000L));
                    SuwellOfdFileUtils.ofdSealAndEncrypt(tpl, output, envelope, null);
                    sr.setResponseData("\u6267\u884cenvelope\u5b8c\u6bd5", "UTF-8");
                }
            }
            sr.setSuccessful(true);
        }
        catch (Throwable e) {
            sr.setSuccessful(false);
        }
        finally {
            sr.sampleEnd();
        }
        return sr;
    }

    private static void pushVarMap4Ebill(Map<String, Object> varMap) {
        varMap.put("acctdate", "2020-07-13");
        varMap.put("transerialno", "0020000488");
        varMap.put("busno", "YzewMOuLrQHs52VQsIvfm0FK1b1kc3eJjsWU0c+fZWA=");
        varMap.put("debitsign", "\u501f\u6b3e");
        varMap.put("payDepName", "\u5f85\u6e05\u7b97\u5546\u6237\u6b3e\u9879");
        varMap.put("payDepAcc", "029100310000050900001");
        varMap.put("paybankname", "\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5317\u4eac\u5174\u878d\u652f\u884c");
        varMap.put("recDepName", "\u4e0a\u6d77\u767e\u5b89\u5c45\u88c5\u9970\u5de5\u7a0b\u6709\u9650\u516c\u53f8\u5317\u4eac\u9a6c\u8fde\u9053\u5206\u516c\u53f8");
        varMap.put("recDepAcc", "0200002109200055860");
        varMap.put("recbankname", "\u73e0\u5e02\u53e3\u5927\u6805\u680f\u652f\u884c");
        varMap.put("accountCur", "\u4eba\u6c11\u5e01(\u672c\u4f4d\u5e01)");
        varMap.put("payamt1", "\u62fe\u4f0d\u5143\u5706\u6574");
        varMap.put("payamt2", "15.00");
        varMap.put("type", "123456");
        varMap.put("vouchtype", "\u51ed\u8bc1\u79cd\u7c7b");
        varMap.put("vouchno", "\u51ed\u8bc1\u53f7");
        varMap.put("summary", "\u6458\u8981");
        varMap.put("useSum", "\u7528\u9014");
        varMap.put("organno", "0020000260");
        varMap.put("areacode", "00200");
        varMap.put("netcode", "00260");
        varMap.put("tellerno", "00023");
        varMap.put("trxcode", "52093");
        varMap.put("cnltype", "\u7f51\u94f6");
        varMap.put("finfo", "<\u6307\u4ee4\u7f16\u53f7>123</\u6307\u4ee4\u7f16\u53f7><\u63d0\u4ea4\u4eba>456</\u63d0\u4ea4\u4eba><\u6700\u7ec8\u6388\u6743\u4eba>789</\u6700\u7ec8\u6388\u6743\u4eba><\u6d41\u6c34\u53f7>000</\u6d41\u6c34\u53f7>");
        varMap.put("accno", "029100310000050900001");
        varMap.put("custidno", "029100310000050900001");
        varMap.put("ebillSeq", "029100310000050900001");
        varMap.put("ebillKey", "029100310000050900001");
        Extend.EleSeal ees = new Extend.EleSeal();
        ees.setName("Suwell_SDK").setPassword("123456").setSealID("101").setLocation(123.04f, 184.89f, 26.0f, 26.0f).setType(Extend.EleSeal.Type.All);
        varMap.put("sealInfo", ees);
        varMap.put("ebillKeyQRStr", "<pub><rd><QT>1</QT><Q><X>1</X><T>4</T><P>4</P><I>${EBBC_EBILL_DOWNLOAD_INSTR.EBILLNO}</I></Q><INFO></INFO></rd></pub>");
    }
}

