/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.Const;
import java.util.EnumMap;
import java.util.Map;

public class SealInfo {
    public static final int TYPE_ALL = -1;
    public static final int TYPE_FIRST = 0;
    public static final int TYPE_LAST = Integer.MAX_VALUE;
    private int type;
    private float x;
    private float y;
    private float width;
    private float height;
    private String sealID;
    private boolean percentPos;
    private String password;
    private int pageIndex;
    private String UserID;
    private String typeC;
    private StampAnnot[] stampAnnot;
    private LocInfo[] locInfos;
    private Map<Const.SignatureExtendKey, String> extend;

    public Map<Const.SignatureExtendKey, String> getExtend() {
        if (this.extend == null) {
            this.extend = new EnumMap<Const.SignatureExtendKey, String>(Const.SignatureExtendKey.class);
        }
        return this.extend;
    }

    public SealInfo(int type, String sealID, float x, float y, String password) {
        if (sealID == null) {
            throw new IllegalArgumentException("sealID cannot be empty !");
        }
        this.type = type;
        this.sealID = sealID;
        this.x = x;
        this.y = y;
        this.password = password;
        this.pageIndex = type;
    }

    @Deprecated
    public SealInfo(int type, String sealID, float x, float y, float width, float height) {
        this.type = type;
        this.sealID = sealID;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Deprecated
    public SealInfo(int type, String sealID, float x, float y, String password, int pageIndex) {
        this.type = type;
        this.sealID = sealID;
        this.x = x;
        this.y = y;
        this.password = password;
        this.pageIndex = pageIndex;
    }

    @Deprecated
    public SealInfo(String sealID, LocInfo ... locInfos) {
        if (locInfos == null || locInfos.length == 0) {
            throw new IllegalArgumentException("locInfos not is null !");
        }
        this.sealID = sealID;
        this.locInfos = locInfos;
    }

    @Deprecated
    public SealInfo(NativeType type, String sealID, float x, float y, float width, float height, String password, int pageIndex, StampAnnot[] stampAnnot) {
        this.typeC = type.toString();
        this.sealID = sealID;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.pageIndex = pageIndex;
        this.password = password;
        this.stampAnnot = stampAnnot;
    }

    @Deprecated
    public SealInfo(NativeType type, String sealID, float x, float y, float width, float height, String password, int pageIndex) {
        this.typeC = type.toString();
        this.sealID = sealID;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.pageIndex = pageIndex;
        this.password = password;
    }

    public String getTypeC() {
        return this.typeC;
    }

    public int getType() {
        return this.type;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public String getSealID() {
        return this.sealID;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public String getUserID() {
        return this.UserID;
    }

    public SealInfo setPassword(String password) {
        this.password = password;
        return this;
    }

    public SealInfo setUserID(String userID) {
        this.UserID = userID;
        return this;
    }

    public SealInfo setPercentPos(boolean percentPos) {
        this.percentPos = percentPos;
        return this;
    }

    public boolean isPercentPos() {
        return this.percentPos;
    }

    public StampAnnot[] getStampAnnot() {
        return this.stampAnnot;
    }

    public LocInfo[] getLocInfos() {
        return this.locInfos;
    }

    public static class StampAnnot {
        private SealInfo info;
        private Type type;

        public StampAnnot(Type type, float x, float y, float width, float height) {
            this.info = new SealInfo(0, null, x, y, width, height);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public float getX() {
            return this.info.getX();
        }

        public float getY() {
            return this.info.getY();
        }

        public float getWidth() {
            return this.info.getWidth();
        }

        public float getHeight() {
            return this.info.height;
        }

        public static enum Type {
            Last,
            First,
            Middle;

        }
    }

    @Deprecated
    public static class LocInfo {
        private float posX;
        private float posY;
        private float width;
        private float height;
        private int index;

        public LocInfo(float x, float y, float width, float height, int index) {
            this.posX = x;
            this.posY = y;
            this.width = width;
            this.height = height;
            this.index = index;
        }

        public LocInfo(float x, float y, int index) {
            this.posX = x;
            this.posY = y;
            this.index = index;
        }

        public float getPosX() {
            return this.posX;
        }

        public float getPosY() {
            return this.posY;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum NativeType {
        Last,
        First,
        All,
        Check,
        Normal;

    }
}

