/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.PackEntry;
import java.io.InputStream;
import java.net.URI;

public class ImageInfo {
    private PackEntry entry;
    private URI uri;
    private String imageType;
    private boolean tile;
    private int opacity;
    private int rotate;
    private int xStep;
    private int yStep;

    public ImageInfo(PackEntry entry, String imageType, int opacity) {
        this.entry = entry;
        this.imageType = imageType;
        this.opacity = opacity < 0 ? 0 : (opacity > 100 ? 100 : opacity);
    }

    public ImageInfo(PackEntry entry, String imageType, int opacity, boolean tile) {
        this(entry, imageType, opacity);
        this.tile = tile;
    }

    public ImageInfo(PackEntry entry, String imageType, int opacity, boolean tile, int rotate) {
        this(entry, imageType, opacity, tile);
        this.rotate = rotate;
    }

    public ImageInfo(InputStream entry, String imageType) {
        this(PackEntry.wrap(entry), imageType, 0);
    }

    public ImageInfo(URI uri, String imageType) {
        this.uri = uri;
        this.imageType = imageType;
    }

    public PackEntry getEntry() {
        return this.entry;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getImageType() {
        return this.imageType;
    }

    public boolean isTile() {
        return this.tile;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getRotate() {
        return this.rotate;
    }

    public int getxStep() {
        return this.xStep;
    }

    public void setxStep(int xStep) {
        this.xStep = xStep;
    }

    public int getyStep() {
        return this.yStep;
    }

    public void setyStep(int yStep) {
        this.yStep = yStep;
    }
}

