/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest digest;
    private boolean isOn = true;

    public DigestInputStream(InputStream stream, MessageDigest digest) {
        super(stream);
        this.digest = digest;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest digest) {
        this.digest = digest;
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.in.read();
        if (this.isOn && byteRead != -1) {
            this.digest.update((byte)byteRead);
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (this.isOn && bytesRead != -1) {
            this.digest.update(b, off, bytesRead);
        }
        return bytesRead;
    }

    public void on(boolean on) {
        this.isOn = on;
    }

    public String toString() {
        return super.toString() + ", " + this.digest.toString() + (this.isOn ? ", is on" : ", is off");
    }
}

