/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class ImageTool {
    public static void compressPictureByQality(BufferedImage src, OutputStream out, float qality, int w, int h) throws IOException {
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D graph = bi.createGraphics();
        graph.drawImage(src.getScaledInstance(w, h, 4), 0, 0, Color.white, null);
        graph.dispose();
        ImageTool.compressPictureByQality(bi, out, qality);
    }

    public static void compressPictureByQality(BufferedImage src, OutputStream out, float qality) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        JPEGImageWriteParam imgWriteParams = new JPEGImageWriteParam(null);
        imgWriteParams.setCompressionMode(2);
        imgWriteParams.setCompressionQuality(qality);
        imgWriteParams.setProgressiveMode(0);
        ColorModel colorModel = src.getColorModel();
        imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        ImageOutputStream iout = ImageIO.createImageOutputStream(out);
        writer.reset();
        writer.setOutput(iout);
        writer.write(null, new IIOImage(src, null, null), imgWriteParams);
        iout.flush();
        iout.close();
    }
}

