/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;

public class URLDownLoader {
    private static int BUFFER_SIZE = 1024000;
    private Vector<String> vDownLoad = new Vector();
    private Vector<String> vFileList = new Vector();

    public void resetList() {
        this.vDownLoad.clear();
        this.vFileList.clear();
    }

    public void addItem(String url, String filename) {
        this.vDownLoad.add(url);
        this.vFileList.add(filename);
    }

    public void downLoadByList() {
        String url = null;
        String filename = null;
        for (int i = 0; i < this.vDownLoad.size(); ++i) {
            url = this.vDownLoad.get(i);
            filename = this.vFileList.get(i);
            try {
                this.saveToFile(url, filename);
                continue;
            }
            catch (IOException err) {
                System.out.println("\u8d44\u6e90[" + url + "]\u4e0b\u8f7d\u5931\u8d25!!!");
                err.printStackTrace();
            }
        }
    }

    public void saveToFile(String destUrl, String fileName) throws IOException {
        FileOutputStream fos = null;
        HttpURLConnection httpUrl = null;
        URL url = null;
        byte[] buf = new byte[BUFFER_SIZE];
        int size = 0;
        url = new URL(destUrl);
        httpUrl = (HttpURLConnection)url.openConnection();
        httpUrl.connect();
        InputStream in = httpUrl.getInputStream();
        fos = new FileOutputStream("C://" + fileName);
        System.out.println("\u6b63\u5728\u83b7\u53d6\u94fe\u63a5[" + destUrl + "]\u7684\u5185\u90e8...\n\u5c06\u5176\u4fdd\u5b58\u4e3a\u6587\u4ef6[" + fileName + "]");
        while ((size = in.read(buf)) != -1) {
            fos.write(buf, 0, size);
        }
        fos.close();
        in.close();
        httpUrl.disconnect();
    }

    public void setProxyServer(String proxy, String proxyPort) {
        System.getProperties().put("proxySet", "true");
        System.getProperties().put("proxyHost", proxy);
        System.getProperties().put("proxyPort", proxyPort);
    }

    public void setAuthenticator(String uid, String pwd) {
    }

    public void getJarResult(String urlPath, String jarName) {
        try {
            long tt = System.currentTimeMillis();
            this.addItem(urlPath, jarName);
            long tt1 = System.currentTimeMillis();
            System.out.println("\u7528\u65f6" + (tt1 -= tt) + "second");
            this.downLoadByList();
        }
        catch (Exception err) {
            System.out.println(err.getMessage());
        }
    }

    public String getConfigFile(String urlPath, String jarName) {
        String path = "";
        try {
            long tt = System.currentTimeMillis();
            this.addItem(urlPath, jarName);
            long tt1 = System.currentTimeMillis();
            System.out.println("\u7528\u65f6" + (tt1 -= tt) + "second");
            this.downLoadByList();
        }
        catch (Exception err) {
            System.out.println(err.getMessage());
        }
        return path;
    }
}

