/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;

public class SystemTools {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final short US_LCID = 1033;
    private static final short ZH_CN_LCID = 2052;
    private static Map<String, Short> lcidMap;
    private static FileSystemView FILESYSVIEW;

    public static boolean isWindows() {
        String os = OS_NAME;
        return os.indexOf("windows") != -1 || os.indexOf("nt") != -1;
    }

    public static boolean isMac() {
        String os = OS_NAME;
        return os.indexOf("mac") != -1;
    }

    public static boolean isLinux() {
        String os = OS_NAME;
        return os.indexOf("linux") != -1;
    }

    public static boolean isWindows9X() {
        String os = OS_NAME;
        return os.equals("windows 95") || os.equals("windows 98");
    }

    public static String getWinntDir() {
        return null;
    }

    public static String getFontDir() {
        return null;
    }

    public static String getTempDir() {
        String val = System.getProperty("java.io.tmpdir");
        if (val == null) {
            System.err.println("envirenment variable 'java.io.tmpdir' is empty!");
            return null;
        }
        return val;
    }

    public static String getCurrentTimeTempDir(String inner) {
        String rs = SystemTools.getTempDir();
        if (inner != null && !"".equals(inner)) {
            rs = rs + File.separator;
            rs = rs + inner;
        }
        String currtime = String.valueOf(System.currentTimeMillis());
        return rs + File.separator + currtime;
    }

    public static int runBatfile(String batfile, String arg) {
        try {
            String cmd = "\"" + batfile + "\" \"" + arg + "\"";
            Runtime.getRuntime().exec(cmd);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int runBatfile(String batfile, String ... args) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\"" + batfile + "\" ");
            for (int i = 0; i < args.length; ++i) {
                sb.append("\"" + args[i] + "\"");
            }
            Runtime.getRuntime().exec(sb.toString());
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getUserDir() {
        String val = System.getProperty("user.home");
        if (val == null) {
            System.err.println("envirenment variable 'user.home' is empty!");
            if (FILESYSVIEW != null) {
                return FILESYSVIEW.getHomeDirectory().getAbsolutePath();
            }
            return null;
        }
        return val;
    }

    public static String getDesktopDir() {
        String val = System.getProperty("user.home");
        if (val == null) {
            System.err.println("envirenment variable 'user.home' is empty!");
            if (FILESYSVIEW != null) {
                return FILESYSVIEW.getHomeDirectory().getAbsolutePath();
            }
            return null;
        }
        return val;
    }

    public static int getLCIDFromLocale(Locale locale) {
        return SystemTools.getLCIDFromLocaleFromFontManager(locale);
    }

    private static short getLCIDFromLocaleFromFontManager(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        if (locale.equals(Locale.PRC)) {
            return 2052;
        }
        if (lcidMap == null) {
            lcidMap = SystemTools.createLCIDMap();
        }
        String key = locale.toString();
        while (!"".equals(key)) {
            Short lcidObject = lcidMap.get(key);
            if (lcidObject != null) {
                return lcidObject;
            }
            int pos = key.lastIndexOf(95);
            if (pos < 1) {
                return 1033;
            }
            key = key.substring(0, pos);
        }
        return 1033;
    }

    private static synchronized Map<String, Short> createLCIDMap() {
        HashMap<String, Short> map = new HashMap<String, Short>(200);
        map.put("ar", (short)1025);
        map.put("bg", (short)1026);
        map.put("ca", (short)1027);
        map.put("zh", (short)1028);
        map.put("cs", (short)1029);
        map.put("da", (short)1030);
        map.put("de", (short)1031);
        map.put("el", (short)1032);
        map.put("es", (short)1034);
        map.put("fi", (short)1035);
        map.put("fr", (short)1036);
        map.put("iw", (short)1037);
        map.put("hu", (short)1038);
        map.put("is", (short)1039);
        map.put("it", (short)1040);
        map.put("ja", (short)1041);
        map.put("ko", (short)1042);
        map.put("nl", (short)1043);
        map.put("no", (short)1044);
        map.put("pl", (short)1045);
        map.put("pt", (short)1046);
        map.put("rm", (short)1047);
        map.put("ro", (short)1048);
        map.put("ru", (short)1049);
        map.put("hr", (short)1050);
        map.put("sk", (short)1051);
        map.put("sq", (short)1052);
        map.put("sv", (short)1053);
        map.put("th", (short)1054);
        map.put("tr", (short)1055);
        map.put("ur", (short)1056);
        map.put("in", (short)1057);
        map.put("uk", (short)1058);
        map.put("be", (short)1059);
        map.put("sl", (short)1060);
        map.put("et", (short)1061);
        map.put("lv", (short)1062);
        map.put("lt", (short)1063);
        map.put("fa", (short)1065);
        map.put("vi", (short)1066);
        map.put("hy", (short)1067);
        map.put("eu", (short)1069);
        map.put("mk", (short)1071);
        map.put("tn", (short)1074);
        map.put("xh", (short)1076);
        map.put("zu", (short)1077);
        map.put("af", (short)1078);
        map.put("ka", (short)1079);
        map.put("fo", (short)1080);
        map.put("hi", (short)1081);
        map.put("mt", (short)1082);
        map.put("se", (short)1083);
        map.put("gd", (short)1084);
        map.put("ms", (short)1086);
        map.put("kk", (short)1087);
        map.put("ky", (short)1088);
        map.put("sw", (short)1089);
        map.put("tt", (short)1092);
        map.put("bn", (short)1093);
        map.put("pa", (short)1094);
        map.put("gu", (short)1095);
        map.put("ta", (short)1097);
        map.put("te", (short)1098);
        map.put("kn", (short)1099);
        map.put("ml", (short)1100);
        map.put("mr", (short)1102);
        map.put("sa", (short)1103);
        map.put("mn", (short)1104);
        map.put("cy", (short)1106);
        map.put("gl", (short)1110);
        map.put("dv", (short)1125);
        map.put("qu", (short)1131);
        map.put("mi", (short)1153);
        map.put("ar_IQ", (short)2049);
        map.put("zh_CN", (short)2052);
        map.put("de_CH", (short)2055);
        map.put("en_GB", (short)2057);
        map.put("es_MX", (short)2058);
        map.put("fr_BE", (short)2060);
        map.put("it_CH", (short)2064);
        map.put("nl_BE", (short)2067);
        map.put("no_NO_NY", (short)2068);
        map.put("pt_PT", (short)2070);
        map.put("ro_MD", (short)2072);
        map.put("ru_MD", (short)2073);
        map.put("sr_CS", (short)2074);
        map.put("sv_FI", (short)2077);
        map.put("az_AZ", (short)2092);
        map.put("se_SE", (short)2107);
        map.put("ga_IE", (short)2108);
        map.put("ms_BN", (short)2110);
        map.put("uz_UZ", (short)2115);
        map.put("qu_EC", (short)2155);
        map.put("ar_EG", (short)3073);
        map.put("zh_HK", (short)3076);
        map.put("de_AT", (short)3079);
        map.put("en_AU", (short)3081);
        map.put("fr_CA", (short)3084);
        map.put("sr_CS", (short)3098);
        map.put("se_FI", (short)3131);
        map.put("qu_PE", (short)3179);
        map.put("ar_LY", (short)4097);
        map.put("zh_SG", (short)4100);
        map.put("de_LU", (short)4103);
        map.put("en_CA", (short)4105);
        map.put("es_GT", (short)4106);
        map.put("fr_CH", (short)4108);
        map.put("hr_BA", (short)4122);
        map.put("ar_DZ", (short)5121);
        map.put("zh_MO", (short)5124);
        map.put("de_LI", (short)5127);
        map.put("en_NZ", (short)5129);
        map.put("es_CR", (short)5130);
        map.put("fr_LU", (short)5132);
        map.put("bs_BA", (short)5146);
        map.put("ar_MA", (short)6145);
        map.put("en_IE", (short)6153);
        map.put("es_PA", (short)6154);
        map.put("fr_MC", (short)6156);
        map.put("sr_BA", (short)6170);
        map.put("ar_TN", (short)7169);
        map.put("en_ZA", (short)7177);
        map.put("es_DO", (short)7178);
        map.put("sr_BA", (short)7194);
        map.put("ar_OM", (short)8193);
        map.put("en_JM", (short)8201);
        map.put("es_VE", (short)8202);
        map.put("ar_YE", (short)9217);
        map.put("es_CO", (short)9226);
        map.put("ar_SY", (short)10241);
        map.put("en_BZ", (short)10249);
        map.put("es_PE", (short)10250);
        map.put("ar_JO", (short)11265);
        map.put("en_TT", (short)11273);
        map.put("es_AR", (short)11274);
        map.put("ar_LB", (short)12289);
        map.put("en_ZW", (short)12297);
        map.put("es_EC", (short)12298);
        map.put("ar_KW", (short)13313);
        map.put("en_PH", (short)13321);
        map.put("es_CL", (short)13322);
        map.put("ar_AE", (short)14337);
        map.put("es_UY", (short)14346);
        map.put("ar_BH", (short)15361);
        map.put("es_PY", (short)15370);
        map.put("ar_QA", (short)16385);
        map.put("es_BO", (short)16394);
        map.put("es_SV", (short)17418);
        map.put("es_HN", (short)18442);
        map.put("es_NI", (short)19466);
        map.put("es_PR", (short)20490);
        return map;
    }

    public static String getOSName() {
        String prop = System.getProperty("os.name");
        if (prop == null) {
            System.err.println("envirenment variable 'os.name' is empty!");
            return "unknown";
        }
        return prop.toLowerCase();
    }

    public static boolean is64Platform() {
        String prop = System.getProperty("os.arch");
        if (prop == null) {
            System.err.println("envirenment variable 'os.name' is empty!");
            return false;
        }
        return prop.endsWith("64");
    }

    public static String getMACAddress() {
        String os = SystemTools.getOSName();
        if (os.startsWith("windows")) {
            return SystemTools.getWindowsMACAddress();
        }
        if (os.startsWith("linux")) {
            return SystemTools.getLinuxMACAddress();
        }
        return SystemTools.getUnixMACAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUnixMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig eth0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("hwaddr");
                if (index == -1) continue;
                mac = line.substring(index + "hwaddr".length() + 1).trim();
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLinuxMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig eth0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("\u786c\u4ef6\u5730\u5740");
                if (index == -1) continue;
                mac = line.substring(index + 4).trim();
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWindowsMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ipconfig /all");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("physical address");
                if (index != -1) {
                    index = line.indexOf(":");
                    if (index != -1) {
                        mac = line.substring(index + 1).trim();
                    }
                } else {
                    index = line.trim().indexOf("\u7269\u7406\u5730\u5740");
                    if (index == -1) continue;
                    index = line.indexOf(":");
                    if (index != -1) {
                        mac = line.substring(index + 1).trim();
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    public static String checkRegistKey(String key) {
        return null;
    }

    public static String getIPAddress() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String ip = addr.getHostAddress().toString();
        return ip;
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    static {
        FILESYSVIEW = FileSystemView.getFileSystemView();
    }
}

