/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NFDParser {
    private static final String OFD_XML = "OFD.xml";
    private static final String NODE_ATTACH_TAG1 = "Attachment";
    private static final String NODE_ATTACH_TAG2 = "Attachments";
    private static final String NODE_DOCROOT_TAG = "DocRoot";
    private static final String NODE_ATTACHMENT = "Attachment";
    private static final String NODE_FILELOC = "FileLoc";
    private static final String NAMESPACE_PREFIX = "ofd";
    private ZipFile nfd;

    public NFDParser(String filePath) throws Exception {
        this.nfd = new ZipFile(filePath);
    }

    public void close() throws Exception {
        this.nfd.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachToFile(String name, String path) throws Exception {
        InputStream is = this.openEntry(name);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        try {
            IOUtils.copy(is, (OutputStream)bos);
        }
        finally {
            bos.close();
            is.close();
        }
    }

    public InputStream getAttachContent(String name) throws Exception {
        return this.openEntry(name);
    }

    public List<String> parseAttachs() throws Exception {
        Element root = this.parseEntry(OFD_XML);
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        this.findAttachementPath(root, "Attachment", paths);
        this.findAttachementPath(root, NODE_ATTACH_TAG2, paths);
        Element docRoot = this.findElement(root, NODE_DOCROOT_TAG);
        if (docRoot != null) {
            String path = docRoot.getTextContent();
            Element ele = this.parseEntry(path);
            this.findAttachementPath(ele, "Attachment", paths);
            this.findAttachementPath(ele, NODE_ATTACH_TAG2, paths);
        }
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String path : paths) {
            String base = "";
            int i = path.indexOf("/");
            if (i > 0) {
                base = path.substring(0, i);
            }
            Element ele = this.parseEntry(path);
            for (Element e : this.findElements(ele, "Attachment")) {
                Element fileLoc = this.findElement(e, NODE_FILELOC);
                if (fileLoc == null) continue;
                String name = fileLoc.getTextContent();
                if (!base.isEmpty()) {
                    if (!name.startsWith("/")) {
                        name = "/" + name;
                    }
                    name = base + name;
                }
                if (list.contains(name)) continue;
                list.add(name);
            }
        }
        return list;
    }

    private Element parseEntry(String entryName) throws Exception {
        InputStream is = this.openEntry(entryName);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(is);
        return doc.getDocumentElement();
    }

    private InputStream openEntry(String entryName) throws FileNotFoundException, IOException, ZipException {
        ZipArchiveEntry entry = this.nfd.getEntry(entryName);
        if (entry == null) {
            throw new FileNotFoundException("\u627e\u4e0d\u5230" + entryName);
        }
        return this.nfd.getInputStream(entry);
    }

    private Element[] findElements(Element root, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        this.findNodes(root, name, list);
        Element[] es = new Element[list.size()];
        return list.toArray(es);
    }

    private void findNodes(Element ele, String name, List<Element> container) {
        NodeList list = ele.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nn = e.getNodeName();
            if (nn.startsWith("ofd:")) {
                nn = nn.substring(NAMESPACE_PREFIX.length() + 1);
            }
            if (nn.equals(name)) {
                container.add(e);
                continue;
            }
            this.findNodes(e, name, container);
        }
    }

    private Element findElement(Element root, String name) {
        Element[] es = this.findElements(root, name);
        if (es == null || es.length == 0) {
            return null;
        }
        return es[0];
    }

    private void findAttachementPath(Element root, String name, Set<String> container) {
        Element ele = this.findElement(root, name);
        if (ele == null) {
            return;
        }
        String path = ele.getTextContent();
        container.add(path);
    }

    public static void main(String[] args) throws Exception {
        NFDParser parser = new NFDParser("C:/1.nfd");
        List<String> attachs = parser.parseAttachs();
        for (String name : attachs) {
            System.out.println(name);
            parser.saveAttachToFile(name, "C:/1_" + name.replace("/", "_"));
        }
        parser.close();
    }
}

