/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

public class MoneyToUpperChinese {
    private static final String[] NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] IUNIT = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] DUNIT = new String[]{"\u89d2", "\u5206", "\u5398"};

    public static synchronized String toChinese(String number) {
        String decimalStr;
        String integerStr;
        if ((number = number.replaceAll(",", "")).indexOf(".") > 0) {
            integerStr = number.substring(0, number.indexOf("."));
            decimalStr = number.substring(number.indexOf(".") + 1);
        } else if (number.indexOf(".") == 0) {
            integerStr = "";
            decimalStr = number.substring(1);
        } else {
            integerStr = number;
            decimalStr = "";
        }
        if (!integerStr.equals("") && (integerStr = Long.toString(Long.parseLong(integerStr))).equals("0")) {
            integerStr = "";
        }
        if (integerStr.length() > IUNIT.length) {
            return number;
        }
        int[] integers = MoneyToUpperChinese.toArray(integerStr);
        boolean isMust5 = MoneyToUpperChinese.isMust5(integerStr);
        int[] decimals = MoneyToUpperChinese.toArray(decimalStr);
        String result = MoneyToUpperChinese.getChineseInteger(integers, isMust5) + MoneyToUpperChinese.getChineseDecimal(decimals);
        if (result.endsWith(IUNIT[0])) {
            result = result + "\u6574";
        }
        return result;
    }

    private static int[] toArray(String number) {
        int[] array = new int[number.length()];
        for (int i = 0; i < number.length(); ++i) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
        }
        return array;
    }

    private static String getChineseInteger(int[] integers, boolean isMust5) {
        StringBuffer chineseInteger = new StringBuffer("");
        int length = integers.length;
        for (int i = 0; i < length; ++i) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = IUNIT[4];
                } else if (length - i == 9) {
                    key = IUNIT[8];
                } else if (length - i == 5 && isMust5) {
                    key = IUNIT[4];
                } else if (length - i == 1) {
                    key = IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = key + NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : NUMBERS[integers[i]] + IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals) {
        StringBuffer chineseDecimal = new StringBuffer("");
        for (int i = 0; i < decimals.length && i != 3; ++i) {
            chineseDecimal.append(decimals[i] == 0 ? "" : NUMBERS[decimals[i]] + DUNIT[i]);
        }
        return chineseDecimal.toString();
    }

    private static boolean isMust5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = "";
            subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }
}

