/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.util.FileTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;

public class HtmlTool {
    public static final void openURL(String urlStr) throws Exception {
        HtmlTool.browse(urlStr);
    }

    public static String postGetResponse(String urlStr, String post) throws IOException {
        URL url = new URL(urlStr);
        return HtmlTool.postGetResponse(url, post);
    }

    public static String postGetResponse(URL url, String post) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setDoOutput(true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(con.getOutputStream(), "utf-8"));
        writer.write(post);
        writer.flush();
        writer.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
        String line = null;
        StringBuilder sbs = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sbs.append(line);
        }
        reader.close();
        con.disconnect();
        String res = sbs.toString();
        return res;
    }

    public static int uploadFileToURL(String urlStr, String filePath) throws IOException {
        URL url = new URL(urlStr);
        return HtmlTool.uploadFileToURL(url, filePath);
    }

    public static int uploadFileToURL(URL url, String filePath) throws IOException {
        String BOUNDARY = "----MyFormBoundarySMFEtUYQG6r5B920";
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Charsert", "UTF-8");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(0);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        StringBuilder sb = new StringBuilder();
        sb.append("--");
        sb.append(BOUNDARY);
        sb.append("\r\n");
        sb.append("Content-Disposition: form-data;name=\"upload\";filename=\"111.dat\"\r\n");
        sb.append("Content-Type:application/octet-stream\r\n\r\n");
        byte[] b = sb.toString().getBytes("UTF-8");
        conn.connect();
        OutputStream os = conn.getOutputStream();
        os.write(b);
        FileTool.saveTo(new File(filePath), os);
        byte[] end = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
        os.write(end);
        os.close();
        int code = conn.getResponseCode();
        conn.disconnect();
        return code;
    }

    public static int uploadFileToServlet(String urlStr, String filePath) throws IOException {
        URL url = new URL(urlStr);
        return HtmlTool.uploadFileToServlet(url, filePath);
    }

    public static int uploadFileToServlet(URL url, String filePath) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(300000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(true);
        conn.setUseCaches(true);
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.connect();
        OutputStream os = conn.getOutputStream();
        FileTool.saveTo(new File(filePath), os);
        os.close();
        int code = conn.getResponseCode();
        conn.disconnect();
        return code;
    }

    private static void browse(String url) throws Exception {
        String osName = System.getProperty("os.name", "");
        if (osName.startsWith("Mac OS")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }
}

