/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import java.text.DecimalFormat;
import java.util.ArrayList;

public class FloatTool {
    public static float[][] groupFloategers(float[] values) {
        float[] newvalue = FloatTool.rankFloats(values, false);
        float last = newvalue[0];
        int group = 0;
        for (int i = 1; i < newvalue.length; ++i) {
            if (newvalue[i] - last != 1.0f) {
                ++group;
            }
            last = newvalue[i];
        }
        float[][] result = new float[group + 1][];
        ArrayList<Float> arr = new ArrayList<Float>();
        last = newvalue[0];
        arr.add(Float.valueOf(newvalue[0]));
        group = 0;
        for (int i = 1; i < newvalue.length; ++i) {
            if (newvalue[i] - last != 1.0f) {
                result[group] = new float[arr.size()];
                for (int k = 0; k < arr.size(); ++k) {
                    result[group][k] = ((Float)arr.get(k)).intValue();
                }
                arr.clear();
                ++group;
            }
            last = newvalue[i];
            arr.add(Float.valueOf(newvalue[i]));
        }
        result[group] = new float[arr.size()];
        for (int k = 0; k < arr.size(); ++k) {
            result[group][k] = ((Float)arr.get(k)).intValue();
        }
        arr.clear();
        return result;
    }

    public static float[] rankFloats(float[] values, boolean reverse) {
        int length = values.length;
        float swap = 0.0f;
        for (int i = 0; i < length - 1; ++i) {
            boolean flag = false;
            for (int j = length - 2; j >= i; --j) {
                if (!reverse) {
                    if (!(values[j + 1] < values[j])) continue;
                    swap = values[j];
                    values[j] = values[j + 1];
                    values[j + 1] = swap;
                    flag = true;
                    continue;
                }
                if (!(values[j + 1] > values[j])) continue;
                swap = values[j];
                values[j] = values[j + 1];
                values[j + 1] = swap;
                flag = true;
            }
            if (!flag) break;
        }
        return values;
    }

    public static float getMaximum(float[] nums) {
        if (nums == null) {
            return Float.MAX_VALUE;
        }
        if (nums.length <= 0) {
            return Float.MAX_VALUE;
        }
        float max = nums[0];
        for (float i : nums) {
            if (!(i > max)) continue;
            max = i;
        }
        return max;
    }

    public static long getMaximum(long[] values) {
        if (values == null) {
            return 0L;
        }
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static float getMinimum(float[] nums) {
        if (nums == null) {
            return Float.MAX_VALUE;
        }
        if (nums.length <= 0) {
            return Float.MAX_VALUE;
        }
        float min = nums[0];
        for (float i : nums) {
            if (!(i < min)) continue;
            min = i;
        }
        return min;
    }

    public static float[] getUniqueNums(float[] nums) {
        if (nums == null || nums.length <= 0) {
            return new float[0];
        }
        ArrayList<Float> arr = new ArrayList<Float>(nums.length);
        for (float i : nums) {
            Float in = new Float(i);
            if (arr.contains(in)) continue;
            arr.add(in);
        }
        float[] result = new float[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            result[i] = ((Float)arr.get(i)).intValue();
        }
        return FloatTool.rankFloats(result, false);
    }

    public static void main(String[] args) {
        float[] is = new float[]{1.001f, 1.003f, 1.005f, 1.007f, 1.009f, 1.011f, 1.013f, 1.015f, 1.017f, 1.019f};
        for (int i = 0; i < is.length; ++i) {
            System.out.println(FloatTool.roundToFlips(is[i], 3));
        }
    }

    public static float[] parseArray(String textContent, String ch) {
        float[] rs = null;
        if (textContent == null || "".equals(textContent)) {
            return rs;
        }
        String[] floatString = textContent.split(ch);
        rs = new float[floatString.length];
        for (int i = 0; i < floatString.length; ++i) {
            rs[i] = Float.parseFloat(floatString[i]);
        }
        return rs;
    }

    public static String floatArrayToString(float[] lineDash, char ch) {
        if (lineDash == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lineDash.length; ++i) {
            sb.append(lineDash[i]);
            if (i >= lineDash.length - 1) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static float[] toFloatArray(double[] arrays) {
        float[] ret = new float[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            ret[i] = (float)arrays[i];
        }
        return ret;
    }

    public static float roundToFlips(float val, int flips) {
        if (flips > 0) {
            String format = "###.";
            while (flips-- > 0) {
                format = format + "0";
            }
            DecimalFormat df2 = new DecimalFormat(format);
            val = Float.valueOf(df2.format(val)).floatValue();
        }
        return val;
    }
}

