/*
 * Decompiled with CFR 0.152.
 */
package cpcns.util;

import cpcns.defs.SimpleFileFilter;
import cpcns.io.DigestOutputStream;
import cpcns.util.ClassTool;
import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import cpcns.util.SystemTools;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileTool {
    public static final int OPTIMAL_SIZE = 0x100000;

    public static boolean fromUrlToLocal(String urlPath, String localPath) throws IOException {
        if (urlPath == null || localPath == null) {
            return false;
        }
        URL url = new URL(urlPath);
        return FileTool.fromUrlToLocal(url, localPath);
    }

    public static boolean fromUrlToLocal(URL url, String localPath) throws IOException {
        if (url == null || localPath == null) {
            return false;
        }
        File file = new File(localPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream os = new FileOutputStream(file);
        byte[] buf = new byte[0x100000];
        int len = -1;
        InputStream uis = url.openConnection().getInputStream();
        while ((len = uis.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        os.close();
        uis.close();
        return true;
    }

    public static OutputStream openOutputUrl(String urlPath) throws IOException {
        if (urlPath == null) {
            return null;
        }
        URL url = new URL(urlPath);
        return FileTool.openOutputUrl(url);
    }

    private static OutputStream openOutputUrl(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setAllowUserInteraction(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.connect();
        OutputStream out = conn.getOutputStream();
        return out;
    }

    public static boolean isRoot(File dir) {
        for (File f : File.listRoots()) {
            if (!f.equals(dir)) continue;
            return true;
        }
        return false;
    }

    public static boolean fileIsOpened(String filename) {
        return FileTool.fileIsOpened(new File(filename));
    }

    public static boolean fileIsOpened(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        boolean flag = false;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileChannel fc = raf.getChannel();
            FileLock lock = fc.tryLock();
            lock.release();
            raf.close();
        }
        catch (IOException e) {
            flag = true;
        }
        return flag;
    }

    public static boolean delete(File file) {
        return FileUtils.deleteQuietly(file);
    }

    public static File getWritableFile(File file) {
        if (!file.exists()) {
            return file;
        }
        if (file.canWrite()) {
            return file;
        }
        String fileName = file.getAbsolutePath();
        String filePath = fileName.substring(0, fileName.lastIndexOf("."));
        String fileType = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        int index = 1;
        fileName = filePath + "_" + index + fileType;
        file = new File(fileName);
        while (file.exists() && index < 100) {
            fileName = filePath + "_" + ++index + fileType;
            file = new File(fileName);
        }
        return FileTool.getWritableFile(file);
    }

    public static File getWritableFile(String filename) {
        File file = new File(filename);
        return FileTool.getWritableFile(file);
    }

    public static boolean writeTo(String content, String filename) throws IOException {
        return FileTool.writeTo(content, "utf-8", filename);
    }

    public static boolean writeTo(String content, OutputStream os) throws IOException {
        return FileTool.writeTo(content, "utf-8", os);
    }

    public static boolean writeTo(String content, String encoding, String filename) throws IOException {
        FileUtils.writeStringToFile(new File(filename), content, encoding);
        return true;
    }

    public static boolean writeTo(String content, String encoding, OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, encoding);
        osw.write(content);
        return true;
    }

    public static boolean saveTo(byte[] buf, String filename) throws IOException {
        if (buf == null || buf.length < 1) {
            return false;
        }
        File file = new File(filename);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileUtils.writeByteArrayToFile(file, buf);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveTo(ByteBuffer buf, File f) throws IOException {
        if (buf == null) {
            return false;
        }
        FileOutputStream fos = new FileOutputStream(f);
        try {
            FileChannel fc = fos.getChannel();
            fc.write(buf);
            fc.close();
            fos.flush();
        }
        finally {
            fos.close();
        }
        return true;
    }

    public static boolean saveTo(InputStream is, OutputStream os) throws IOException {
        if (os == null || is == null) {
            return false;
        }
        IOUtils.copy(is, os);
        return true;
    }

    public static boolean copyTo(String src, String destFile) throws IOException {
        File s = new File(src);
        File d = new File(destFile);
        return FileTool.copyTo(s, d);
    }

    public static boolean mkDir(String path) {
        File file = new File(path);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean mkFileDirs(String filePath) {
        String tmpStr = filePath.replace("\\", "/");
        int index = tmpStr.lastIndexOf("/");
        if (index == -1) {
            return false;
        }
        File file = new File(tmpStr = tmpStr.substring(0, index));
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean copyTo(File src, File des) throws IOException {
        if (!src.exists()) {
            return false;
        }
        if (src.isFile()) {
            FileUtils.copyFile(src, des);
            return true;
        }
        des.mkdirs();
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getAbsolutePath();
            String name = path.substring(path.lastIndexOf(File.separator));
            if (FileTool.copyTo(files[i], new File(des.getAbsolutePath() + name))) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveTo(InputStream is, File destFile) throws IOException {
        if (is == null) {
            return false;
        }
        File f = new File(destFile.getParent());
        if (!f.exists()) {
            f.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            IOUtils.copy(is, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        return true;
    }

    public static boolean saveTo(String srcFileName, OutputStream os) throws IOException {
        return FileTool.saveTo(new File(srcFileName), os);
    }

    public static boolean saveTo(File srcFile, OutputStream os) throws IOException {
        FileInputStream is = new FileInputStream(srcFile);
        try {
            IOUtils.copy((InputStream)is, os);
        }
        finally {
            is.close();
        }
        return true;
    }

    public static boolean saveTo(InputStream is, String filename) throws IOException {
        File f = new File(filename);
        return FileTool.saveTo(is, f);
    }

    public static String readToString(URL url) throws IOException {
        InputStream is = url.openStream();
        String cont = FileTool.readToString(is, "utf-8");
        is.close();
        return cont;
    }

    public static String readToString(String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        String cont = FileTool.readToString(is, "utf-8");
        ((InputStream)is).close();
        return cont;
    }

    public static String readToString(File file, String encoding) throws IOException {
        FileInputStream is = new FileInputStream(file);
        String cont = FileTool.readToString(is, encoding);
        ((InputStream)is).close();
        return cont;
    }

    public static String readStrFromStream(InputStream is) throws IOException {
        String charset = Charset.defaultCharset().name();
        return FileTool.readToString(is, charset);
    }

    public static String readToString(InputStream is, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, encoding);
        BufferedReader b = new BufferedReader(reader);
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = b.readLine()) != null) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    public static String getFileRoot(String file) {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        while (f.getParent() != null) {
            f = f.getParentFile();
        }
        return f.getAbsolutePath();
    }

    public static Map<String, String> readProperties(String filePath) throws IOException {
        Properties p = new Properties();
        FileInputStream is = new FileInputStream(filePath);
        p.load(is);
        ((InputStream)is).close();
        Enumeration<Object> keys = p.keys();
        HashMap<String, String> map = new HashMap<String, String>();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = p.get(key);
            map.put(key.toString(), val.toString());
        }
        return map;
    }

    public static void saveProperties(Map<String, String> map, String destPath) throws IOException {
        Properties p = new Properties();
        for (String key : map.keySet()) {
            String val = map.get(key);
            p.put(key, val);
        }
        FileOutputStream os = new FileOutputStream(destPath);
        p.store(os, "update at " + new Date());
    }

    public static FileReader getFileReader(String name) throws FileNotFoundException {
        String dir = System.getProperty("java.io.tmpdir");
        if (dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return new FileReader(dir + name + ".txt");
    }

    public static void padBlank(Writer writer, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            writer.write("    ");
        }
    }

    public static void padEnter(Writer writer) throws IOException {
        writer.write("\r\n");
    }

    public static byte[] getDataDigest(String filename) throws IOException {
        File file = new File(filename);
        return FileTool.getDataDigest(file);
    }

    public static byte[] getDataDigest(File file) throws IOException {
        String name = file.getAbsolutePath();
        if (name.indexOf("~$") > 0) {
            String e = name.substring(0, name.indexOf("~$"));
            file = new File(e);
        }
        FileInputStream is = new FileInputStream(file);
        byte[] digest = FileTool.getDataDigest(is);
        ((InputStream)is).close();
        return digest;
    }

    public static byte[] getDataDigest(InputStream is) throws IOException {
        try {
            return FileTool.getDataDigest(is, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("\u4e0d\u652f\u6301\u6458\u8981\u7b97\u6cd5[SHA-256]");
        }
    }

    public static byte[] getDataDigest(InputStream is, String algorithm) throws IOException, NoSuchAlgorithmException {
        DigestOutputStream os = new DigestOutputStream(algorithm);
        FileTool.saveTo(is, (OutputStream)os);
        byte[] buf = os.getDigest();
        os.close();
        os = null;
        return buf;
    }

    public static String findFileInDirectory(File dir, String filename) {
        String f;
        int i;
        if (dir == null) {
            return null;
        }
        if (dir.isFile()) {
            if (dir.getName().equals(filename)) {
                return dir.getAbsolutePath();
            }
            return null;
        }
        File[] files = dir.listFiles();
        for (i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() || (f = FileTool.findFileInDirectory(files[i], filename)) == null) continue;
            return f;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i].isFile() || (f = FileTool.findFileInDirectory(files[i], filename)) == null) continue;
            return f;
        }
        return null;
    }

    public static int getFileCountInDirectory(File dir, String suffix) {
        SimpleFileFilter filter = new SimpleFileFilter(suffix);
        return FileTool.getFileCountInDirectory(dir, filter);
    }

    public static int getFileCountInDirectory(File dir, FileFilter filter) {
        if (dir.isFile()) {
            return filter.accept(dir) ? 1 : 0;
        }
        int n = 0;
        File[] files = dir.listFiles();
        if (files == null) {
            return n;
        }
        for (int i = 0; i < files.length; ++i) {
            n += FileTool.getFileCountInDirectory(files[i], filter);
        }
        return n;
    }

    public static List<File> getFileListInDirectory(File dir, String suffix) {
        SimpleFileFilter filter = new SimpleFileFilter(suffix);
        return FileTool.getFileListInDirectory(dir, filter);
    }

    public static List<File> getFileListInDirectory(File dir, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        FileTool.getFileListInDirectory(dir, filter, files);
        return files;
    }

    private static void getFileListInDirectory(File dir, FileFilter filter, List<File> result) {
        if (dir.isFile()) {
            if (filter.accept(dir)) {
                result.add(dir);
            }
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            FileTool.getFileListInDirectory(files[i], filter, result);
        }
    }

    public static String getDigestId(String path) throws IOException {
        File f = new File(path);
        String pname = f.getName();
        int index = pname.indexOf("~$");
        if (index > -1) {
            String file = pname.substring(0, index);
            f = new File(f.getParentFile(), file);
        }
        String txt = FileTool.getDigestId(f);
        if (index > -1) {
            txt = txt + pname.substring(index);
        }
        return txt;
    }

    public static String getDigestId(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        String de = FileTool.getDigestId(is);
        ((InputStream)is).close();
        return de;
    }

    public static String getDigestId(InputStream is) throws IOException {
        DigestOutputStream os = null;
        try {
            os = new DigestOutputStream("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5[SHA-256]");
        }
        FileTool.saveTo(is, (OutputStream)os);
        String txt = os.getDigestText();
        os.close();
        os = null;
        return txt;
    }

    public static byte[] readToByte(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[0x100000];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while ((read = in.read(buffer)) != -1) {
            outStream.write(buffer, 0, read);
        }
        outStream.close();
        return outStream.toByteArray();
    }

    public static byte[] readToByte(InputStream in, byte[] buf) throws IOException {
        int len;
        int offset = 0;
        while ((len = in.read(buf, offset, 0x100000)) != -1) {
            offset += len;
        }
        return buf;
    }

    public static byte[] readToByte(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] ret = FileTool.readToByte(is);
        is.close();
        is = null;
        return ret;
    }

    public static byte[] readToByte(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        return FileTool.readToByte(file);
    }

    public static void open(File file) {
        Class<?> desktopClass = ClassTool.getClass("java.awt.Desktop");
        if (desktopClass != null) {
            Object dt = ClassTool.invokeStaticMethod(desktopClass, "getDesktop", null, null);
            if (dt != null) {
                ClassTool.invokeMethod(desktopClass, dt, "open", new Class[]{file.getClass()}, new Object[]{file});
            } else {
                System.err.println("Desktop.getDesktop().open() \u6253\u5f00\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5173\u8054\u3002");
            }
        } else {
            String fileName = file.getAbsolutePath();
            String cmd = null;
            if (SystemTools.isLinux()) {
                cmd = String.format("gnome-open %s", fileName);
            } else if (SystemTools.isMac()) {
                cmd = String.format("open %s", fileName);
            } else if (SystemTools.isWindows() && SystemTools.isWindows9X()) {
                cmd = String.format("command.com /C start %s", fileName);
            } else if (SystemTools.isWindows()) {
                cmd = String.format("cmd /c start %s", fileName);
            }
            if (cmd != null) {
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

