/*
 * Decompiled with CFR 0.152.
 */
package cpcns.security;

import cpcns.security.IDecryptKey;
import cpcns.security.IEncryptKey;
import cpcns.security.ISignatureKey;
import cpcns.security.IVerifySignKey;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UKeyFactory {
    private static List<String> providers = new ArrayList<String>();
    private static List<Map<String, String>> keys = new ArrayList<Map<String, String>>();
    public static final String USAGE_ENCRYPT = "Encrypt";
    public static final String USAGE_DECRYPT = "Decrypt";
    public static final String USAGE_SIGNATURE = "Signature";
    public static final String USAGE_VALIDSIGN = "ValidSign";

    public static void registEnKey(String provider, String usage, String className) {
        UKeyFactory.registKey(provider, USAGE_ENCRYPT, className);
    }

    public static void registDeKey(String provider, String usage, String className) {
        UKeyFactory.registKey(provider, USAGE_DECRYPT, className);
    }

    public static void registSnKey(String provider, String usage, String className) {
        UKeyFactory.registKey(provider, USAGE_SIGNATURE, className);
    }

    public static void registVsKey(String provider, String usage, String className) {
        UKeyFactory.registKey(provider, USAGE_VALIDSIGN, className);
    }

    public static void registKey(String provider, String usage, String className) {
        int index = providers.indexOf(provider);
        if (index > -1) {
            Map<String, String> map = keys.get(index);
            map.put(usage, className);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(usage, className);
            providers.add(provider);
            keys.add(map);
        }
    }

    public static IEncryptKey getEncryptKey(String provider) throws Exception {
        for (int i = 0; i < providers.size(); ++i) {
            Map<String, String> map;
            String cls;
            String pro = providers.get(i);
            if (!pro.equalsIgnoreCase(provider) || (cls = (map = keys.get(i)).get(USAGE_ENCRYPT)) == null) continue;
            return UKeyFactory.instance(IEncryptKey.class, cls);
        }
        return null;
    }

    public static IDecryptKey getDecryptKey(String provider) throws Exception {
        for (int i = 0; i < providers.size(); ++i) {
            Map<String, String> map;
            String cls;
            String pro = providers.get(i);
            if (!pro.equalsIgnoreCase(provider) || (cls = (map = keys.get(i)).get(USAGE_DECRYPT)) == null) continue;
            return UKeyFactory.instance(IDecryptKey.class, cls);
        }
        return null;
    }

    public static ISignatureKey getSignatureKey(String provider) throws Exception {
        for (int i = 0; i < providers.size(); ++i) {
            Map<String, String> map;
            String cls;
            String pro = providers.get(i);
            if (!pro.equalsIgnoreCase(provider) || (cls = (map = keys.get(i)).get(USAGE_SIGNATURE)) == null) continue;
            return UKeyFactory.instance(ISignatureKey.class, cls);
        }
        return null;
    }

    public static IVerifySignKey getValidSignKey(String provider) throws Exception {
        for (int i = 0; i < providers.size(); ++i) {
            Map<String, String> map;
            String cls;
            String pro = providers.get(i);
            if (!pro.equalsIgnoreCase(provider) || (cls = (map = keys.get(i)).get(USAGE_VALIDSIGN)) == null) continue;
            return UKeyFactory.instance(IVerifySignKey.class, cls);
        }
        return null;
    }

    private static <T> T instance(Class<T> clazz, String cls) throws Exception {
        Class<?> c = Class.forName(cls);
        Object o = null;
        try {
            Method m = c.getMethod("getInstance", new Class[0]);
            if (m != null && Modifier.isStatic(m.getModifiers())) {
                o = m.invoke(c, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (o == null) {
            o = c.newInstance();
        }
        return clazz.cast(o);
    }

    public List<String> getSignatureProvider() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < providers.size(); ++i) {
            Map<String, String> map = keys.get(i);
            if (!map.containsKey(USAGE_SIGNATURE)) continue;
            result.add(providers.get(i));
        }
        return result;
    }

    public List<String> getEncryptProvider() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < providers.size(); ++i) {
            Map<String, String> map = keys.get(i);
            if (!map.containsKey(USAGE_ENCRYPT)) continue;
            result.add(providers.get(i));
        }
        return result;
    }

    static {
        UKeyFactory.registEnKey("JCE", USAGE_ENCRYPT, "cpcns.security.JCEKey");
        UKeyFactory.registDeKey("JCE", USAGE_DECRYPT, "cpcns.security.JCEKey");
        UKeyFactory.registSnKey("JCE", USAGE_SIGNATURE, "cpcns.security.JCEKey");
        UKeyFactory.registVsKey("JCE", USAGE_VALIDSIGN, "cpcns.security.JCEKey");
        UKeyFactory.registEnKey("CAPICOM", USAGE_ENCRYPT, "cpcns.security.BCapicomKey");
        UKeyFactory.registDeKey("CAPICOM", USAGE_DECRYPT, "cpcns.security.BCapicomKey");
        UKeyFactory.registSnKey("CAPICOM", USAGE_SIGNATURE, "cpcns.security.CapicomKey");
        UKeyFactory.registVsKey("CAPICOM", USAGE_VALIDSIGN, "cpcns.security.CapicomKey");
        UKeyFactory.registEnKey("FEITIAN", USAGE_ENCRYPT, "cpcns.security.FeiTianKey");
        UKeyFactory.registDeKey("FEITIAN", USAGE_DECRYPT, "cpcns.security.FeiTianKey");
        UKeyFactory.registSnKey("FEITIAN", USAGE_SIGNATURE, "cpcns.security.FeiTianKey");
        UKeyFactory.registVsKey("FEITIAN", USAGE_VALIDSIGN, "cpcns.security.FeiTianKey");
    }
}

