/*
 * Decompiled with CFR 0.152.
 */
package cpcns.lang.character;

import cpcns.lang.character.CharacterData;
import cpcns.lang.character.Characters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public enum UnicodeScript {
    COMMON,
    LATIN,
    GREEK,
    CYRILLIC,
    ARMENIAN,
    HEBREW,
    ARABIC,
    SYRIAC,
    THAANA,
    DEVANAGARI,
    BENGALI,
    GURMUKHI,
    GUJARATI,
    ORIYA,
    TAMIL,
    TELUGU,
    KANNADA,
    MALAYALAM,
    SINHALA,
    THAI,
    LAO,
    TIBETAN,
    MYANMAR,
    GEORGIAN,
    HANGUL,
    ETHIOPIC,
    CHEROKEE,
    CANADIAN_ABORIGINAL,
    OGHAM,
    RUNIC,
    KHMER,
    MONGOLIAN,
    HIRAGANA,
    KATAKANA,
    BOPOMOFO,
    HAN,
    YI,
    OLD_ITALIC,
    GOTHIC,
    DESERET,
    INHERITED,
    TAGALOG,
    HANUNOO,
    BUHID,
    TAGBANWA,
    LIMBU,
    TAI_LE,
    LINEAR_B,
    UGARITIC,
    SHAVIAN,
    OSMANYA,
    CYPRIOT,
    BRAILLE,
    BUGINESE,
    COPTIC,
    NEW_TAI_LUE,
    GLAGOLITIC,
    TIFINAGH,
    SYLOTI_NAGRI,
    OLD_PERSIAN,
    KHAROSHTHI,
    BALINESE,
    CUNEIFORM,
    PHOENICIAN,
    PHAGS_PA,
    NKO,
    SUNDANESE,
    BATAK,
    LEPCHA,
    OL_CHIKI,
    VAI,
    SAURASHTRA,
    KAYAH_LI,
    REJANG,
    LYCIAN,
    CARIAN,
    LYDIAN,
    CHAM,
    TAI_THAM,
    TAI_VIET,
    AVESTAN,
    EGYPTIAN_HIEROGLYPHS,
    SAMARITAN,
    MANDAIC,
    LISU,
    BAMUM,
    JAVANESE,
    MEETEI_MAYEK,
    IMPERIAL_ARAMAIC,
    OLD_SOUTH_ARABIAN,
    INSCRIPTIONAL_PARTHIAN,
    INSCRIPTIONAL_PAHLAVI,
    OLD_TURKIC,
    BRAHMI,
    KAITHI,
    MEROITIC_HIEROGLYPHS,
    MEROITIC_CURSIVE,
    SORA_SOMPENG,
    CHAKMA,
    SHARADA,
    TAKRI,
    MIAO,
    UNKNOWN;

    private static final int[] scriptStarts;
    private static final UnicodeScript[] scripts;
    private static HashMap<String, UnicodeScript> aliases;

    public static UnicodeScript of(int codePoint) {
        if (!Characters.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        int type = CharacterData.of(codePoint).getType(codePoint);
        if (type == 0) {
            return UNKNOWN;
        }
        int index = Arrays.binarySearch(scriptStarts, codePoint);
        if (index < 0) {
            index = -index - 2;
        }
        return scripts[index];
    }

    public static final UnicodeScript forName(String scriptName) {
        UnicodeScript sc = aliases.get(scriptName = scriptName.toUpperCase(Locale.ENGLISH));
        if (sc != null) {
            return sc;
        }
        return UnicodeScript.valueOf(scriptName);
    }

    static {
        scriptStarts = new int[]{0, 65, 91, 97, 123, 170, 171, 186, 187, 192, 215, 216, 247, 248, 697, 736, 741, 746, 748, 768, 880, 884, 885, 894, 900, 901, 902, 903, 904, 994, 1008, 1024, 1157, 1159, 1329, 1417, 1418, 1425, 1536, 1548, 1549, 1563, 1566, 1567, 1568, 1600, 1601, 1611, 1622, 1632, 1642, 1648, 1649, 1757, 1758, 1792, 1872, 1920, 1984, 2048, 2112, 2208, 2304, 2385, 2387, 2404, 2406, 2433, 2561, 2689, 2817, 2946, 3073, 3202, 3330, 3458, 3585, 3647, 3648, 3713, 3840, 4053, 4057, 4096, 4256, 4347, 4348, 4352, 4608, 5024, 5120, 5760, 5792, 5867, 5870, 5888, 5920, 5941, 5952, 5984, 6016, 6144, 6146, 6148, 6149, 6150, 6320, 6400, 6480, 6528, 6624, 6656, 6688, 6912, 7040, 7104, 7168, 7248, 7360, 7376, 7379, 7380, 7393, 7394, 7401, 7405, 7406, 7412, 7413, 7424, 7462, 7467, 7468, 7517, 7522, 7526, 7531, 7544, 7545, 7615, 7616, 7680, 7936, 8192, 8204, 8206, 8305, 8308, 8319, 8320, 8336, 8352, 8400, 8448, 8486, 8487, 8490, 8492, 8498, 8499, 8526, 8527, 8544, 8585, 10240, 10496, 11264, 11360, 11392, 11520, 11568, 11648, 11744, 11776, 11904, 12272, 12293, 12294, 12295, 12296, 12321, 12330, 12334, 12336, 12344, 12348, 12353, 12441, 12443, 12445, 12448, 12449, 12539, 12541, 12549, 12593, 12688, 12704, 12736, 12784, 12800, 12832, 12896, 12927, 13008, 13144, 13312, 19904, 19968, 40960, 42192, 42240, 42560, 42656, 42752, 42786, 42888, 42891, 43008, 43056, 43072, 43136, 43232, 43264, 43312, 43360, 43392, 43520, 43616, 43648, 43744, 43777, 43968, 44032, 55292, 63744, 64256, 64275, 64285, 64336, 64830, 64848, 65021, 65024, 65040, 65056, 65072, 65136, 65279, 65313, 65339, 65345, 65371, 65382, 65392, 65393, 65438, 65440, 65504, 65536, 65792, 65856, 65936, 66045, 66176, 66208, 66304, 66352, 66432, 66464, 66560, 66640, 66688, 67584, 67648, 67840, 67872, 67968, 68000, 68096, 68192, 68352, 68416, 68448, 68608, 69216, 69632, 69760, 69840, 69888, 70016, 71296, 73728, 77824, 92160, 93952, 110592, 110593, 118784, 119143, 119146, 119163, 119171, 119173, 119180, 119210, 119214, 119296, 119552, 126464, 126976, 127488, 127489, 131072, 917505, 917760, 918000};
        scripts = new UnicodeScript[]{COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, BOPOMOFO, COMMON, INHERITED, GREEK, COMMON, GREEK, COMMON, GREEK, COMMON, GREEK, COMMON, GREEK, COPTIC, GREEK, CYRILLIC, INHERITED, CYRILLIC, ARMENIAN, COMMON, ARMENIAN, HEBREW, ARABIC, COMMON, ARABIC, COMMON, ARABIC, COMMON, ARABIC, COMMON, ARABIC, INHERITED, ARABIC, COMMON, ARABIC, INHERITED, ARABIC, COMMON, ARABIC, SYRIAC, ARABIC, THAANA, NKO, SAMARITAN, MANDAIC, ARABIC, DEVANAGARI, INHERITED, DEVANAGARI, COMMON, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, COMMON, THAI, LAO, TIBETAN, COMMON, TIBETAN, MYANMAR, GEORGIAN, COMMON, GEORGIAN, HANGUL, ETHIOPIC, CHEROKEE, CANADIAN_ABORIGINAL, OGHAM, RUNIC, COMMON, RUNIC, TAGALOG, HANUNOO, COMMON, BUHID, TAGBANWA, KHMER, MONGOLIAN, COMMON, MONGOLIAN, COMMON, MONGOLIAN, CANADIAN_ABORIGINAL, LIMBU, TAI_LE, NEW_TAI_LUE, KHMER, BUGINESE, TAI_THAM, BALINESE, SUNDANESE, BATAK, LEPCHA, OL_CHIKI, SUNDANESE, INHERITED, COMMON, INHERITED, COMMON, INHERITED, COMMON, INHERITED, COMMON, INHERITED, COMMON, LATIN, GREEK, CYRILLIC, LATIN, GREEK, LATIN, GREEK, LATIN, CYRILLIC, LATIN, GREEK, INHERITED, LATIN, GREEK, COMMON, INHERITED, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, INHERITED, COMMON, GREEK, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, LATIN, COMMON, BRAILLE, COMMON, GLAGOLITIC, LATIN, COPTIC, GEORGIAN, TIFINAGH, ETHIOPIC, CYRILLIC, COMMON, HAN, COMMON, HAN, COMMON, HAN, COMMON, HAN, INHERITED, HANGUL, COMMON, HAN, COMMON, HIRAGANA, INHERITED, COMMON, HIRAGANA, COMMON, KATAKANA, COMMON, KATAKANA, BOPOMOFO, HANGUL, COMMON, BOPOMOFO, COMMON, KATAKANA, HANGUL, COMMON, HANGUL, COMMON, KATAKANA, COMMON, HAN, COMMON, HAN, YI, LISU, VAI, CYRILLIC, BAMUM, COMMON, LATIN, COMMON, LATIN, SYLOTI_NAGRI, COMMON, PHAGS_PA, SAURASHTRA, DEVANAGARI, KAYAH_LI, REJANG, HANGUL, JAVANESE, CHAM, MYANMAR, TAI_VIET, MEETEI_MAYEK, ETHIOPIC, MEETEI_MAYEK, HANGUL, UNKNOWN, HAN, LATIN, ARMENIAN, HEBREW, ARABIC, COMMON, ARABIC, COMMON, INHERITED, COMMON, INHERITED, COMMON, ARABIC, COMMON, LATIN, COMMON, LATIN, COMMON, KATAKANA, COMMON, KATAKANA, COMMON, HANGUL, COMMON, LINEAR_B, COMMON, GREEK, COMMON, INHERITED, LYCIAN, CARIAN, OLD_ITALIC, GOTHIC, UGARITIC, OLD_PERSIAN, DESERET, SHAVIAN, OSMANYA, CYPRIOT, IMPERIAL_ARAMAIC, PHOENICIAN, LYDIAN, MEROITIC_HIEROGLYPHS, MEROITIC_CURSIVE, KHAROSHTHI, OLD_SOUTH_ARABIAN, AVESTAN, INSCRIPTIONAL_PARTHIAN, INSCRIPTIONAL_PAHLAVI, OLD_TURKIC, ARABIC, BRAHMI, KAITHI, SORA_SOMPENG, CHAKMA, SHARADA, TAKRI, CUNEIFORM, EGYPTIAN_HIEROGLYPHS, BAMUM, MIAO, KATAKANA, HIRAGANA, COMMON, INHERITED, COMMON, INHERITED, COMMON, INHERITED, COMMON, INHERITED, COMMON, GREEK, COMMON, ARABIC, COMMON, HIRAGANA, COMMON, HAN, COMMON, INHERITED, UNKNOWN};
        aliases = new HashMap(128);
        aliases.put("ARAB", ARABIC);
        aliases.put("ARMI", IMPERIAL_ARAMAIC);
        aliases.put("ARMN", ARMENIAN);
        aliases.put("AVST", AVESTAN);
        aliases.put("BALI", BALINESE);
        aliases.put("BAMU", BAMUM);
        aliases.put("BATK", BATAK);
        aliases.put("BENG", BENGALI);
        aliases.put("BOPO", BOPOMOFO);
        aliases.put("BRAI", BRAILLE);
        aliases.put("BRAH", BRAHMI);
        aliases.put("BUGI", BUGINESE);
        aliases.put("BUHD", BUHID);
        aliases.put("CAKM", CHAKMA);
        aliases.put("CANS", CANADIAN_ABORIGINAL);
        aliases.put("CARI", CARIAN);
        aliases.put("CHAM", CHAM);
        aliases.put("CHER", CHEROKEE);
        aliases.put("COPT", COPTIC);
        aliases.put("CPRT", CYPRIOT);
        aliases.put("CYRL", CYRILLIC);
        aliases.put("DEVA", DEVANAGARI);
        aliases.put("DSRT", DESERET);
        aliases.put("EGYP", EGYPTIAN_HIEROGLYPHS);
        aliases.put("ETHI", ETHIOPIC);
        aliases.put("GEOR", GEORGIAN);
        aliases.put("GLAG", GLAGOLITIC);
        aliases.put("GOTH", GOTHIC);
        aliases.put("GREK", GREEK);
        aliases.put("GUJR", GUJARATI);
        aliases.put("GURU", GURMUKHI);
        aliases.put("HANG", HANGUL);
        aliases.put("HANI", HAN);
        aliases.put("HANO", HANUNOO);
        aliases.put("HEBR", HEBREW);
        aliases.put("HIRA", HIRAGANA);
        aliases.put("ITAL", OLD_ITALIC);
        aliases.put("JAVA", JAVANESE);
        aliases.put("KALI", KAYAH_LI);
        aliases.put("KANA", KATAKANA);
        aliases.put("KHAR", KHAROSHTHI);
        aliases.put("KHMR", KHMER);
        aliases.put("KNDA", KANNADA);
        aliases.put("KTHI", KAITHI);
        aliases.put("LANA", TAI_THAM);
        aliases.put("LAOO", LAO);
        aliases.put("LATN", LATIN);
        aliases.put("LEPC", LEPCHA);
        aliases.put("LIMB", LIMBU);
        aliases.put("LINB", LINEAR_B);
        aliases.put("LISU", LISU);
        aliases.put("LYCI", LYCIAN);
        aliases.put("LYDI", LYDIAN);
        aliases.put("MAND", MANDAIC);
        aliases.put("MERC", MEROITIC_CURSIVE);
        aliases.put("MERO", MEROITIC_HIEROGLYPHS);
        aliases.put("MLYM", MALAYALAM);
        aliases.put("MONG", MONGOLIAN);
        aliases.put("MTEI", MEETEI_MAYEK);
        aliases.put("MYMR", MYANMAR);
        aliases.put("NKOO", NKO);
        aliases.put("OGAM", OGHAM);
        aliases.put("OLCK", OL_CHIKI);
        aliases.put("ORKH", OLD_TURKIC);
        aliases.put("ORYA", ORIYA);
        aliases.put("OSMA", OSMANYA);
        aliases.put("PHAG", PHAGS_PA);
        aliases.put("PLRD", MIAO);
        aliases.put("PHLI", INSCRIPTIONAL_PAHLAVI);
        aliases.put("PHNX", PHOENICIAN);
        aliases.put("PRTI", INSCRIPTIONAL_PARTHIAN);
        aliases.put("RJNG", REJANG);
        aliases.put("RUNR", RUNIC);
        aliases.put("SAMR", SAMARITAN);
        aliases.put("SARB", OLD_SOUTH_ARABIAN);
        aliases.put("SAUR", SAURASHTRA);
        aliases.put("SHAW", SHAVIAN);
        aliases.put("SHRD", SHARADA);
        aliases.put("SINH", SINHALA);
        aliases.put("SORA", SORA_SOMPENG);
        aliases.put("SUND", SUNDANESE);
        aliases.put("SYLO", SYLOTI_NAGRI);
        aliases.put("SYRC", SYRIAC);
        aliases.put("TAGB", TAGBANWA);
        aliases.put("TALE", TAI_LE);
        aliases.put("TAKR", TAKRI);
        aliases.put("TALU", NEW_TAI_LUE);
        aliases.put("TAML", TAMIL);
        aliases.put("TAVT", TAI_VIET);
        aliases.put("TELU", TELUGU);
        aliases.put("TFNG", TIFINAGH);
        aliases.put("TGLG", TAGALOG);
        aliases.put("THAA", THAANA);
        aliases.put("THAI", THAI);
        aliases.put("TIBT", TIBETAN);
        aliases.put("UGAR", UGARITIC);
        aliases.put("VAII", VAI);
        aliases.put("XPEO", OLD_PERSIAN);
        aliases.put("XSUX", CUNEIFORM);
        aliases.put("YIII", YI);
        aliases.put("ZINH", INHERITED);
        aliases.put("ZYYY", COMMON);
        aliases.put("ZZZZ", UNKNOWN);
    }
}

