/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.io.ByteArrayReleaseInputStream;
import cpcns.io.DisposeInputStream;
import cpcns.io.RandomAccessFileInputStream;
import cpcns.io.ReleasableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WisdomOutputStream
extends OutputStream {
    public static final long M_1 = 0x100000L;
    public static final long M_3 = 0x300000L;
    public static final long M_5 = 0x500000L;
    public static final long M_10 = 0xA00000L;
    private final long max;
    private ByteArrayOutputStream mos;
    private File file;
    private FileOutputStream fos;
    private boolean fosClosed;
    private long length;
    private boolean deleteFileWhenClosed;

    public WisdomOutputStream(long max) {
        this(max, false);
    }

    public WisdomOutputStream(long max, boolean deleteFileWhenClosed) {
        this.max = max;
        this.mos = new ByteArrayOutputStream();
        this.deleteFileWhenClosed = deleteFileWhenClosed;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.length > this.max) {
            this.forceFlush();
        }
        this.mos.write(b);
        ++this.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.length + (long)len > this.max) {
            this.forceFlush();
        }
        this.mos.write(b, off, len);
        this.length += (long)len;
    }

    private synchronized void forceFlush() throws IOException {
        if (this.file == null) {
            this.file = File.createTempFile("wos_", ".out");
            this.fos = new FileOutputStream(this.file);
        }
        this.mos.writeTo(this.fos);
        this.mos.reset();
        this.length = 0L;
    }

    public boolean inMemory() {
        return this.file == null;
    }

    public byte[] toByteArray() throws IOException {
        if (!this.inMemory()) {
            throw new IOException("Some data store in file!");
        }
        return this.mos.toByteArray();
    }

    public File toFile() throws IOException {
        if (!this.fosClosed) {
            this.forceFlush();
            this.fos.close();
            this.fosClosed = true;
        }
        return this.file;
    }

    public ReleasableInputStream toInputStream() throws IOException {
        if (this.inMemory()) {
            return new ByteArrayReleaseInputStream(this.mos.toByteArray());
        }
        return new DisposeInputStream(new RandomAccessFileInputStream(this.toFile(), this.deleteFileWhenClosed));
    }

    @Override
    public void flush() throws IOException {
        if (this.fos != null) {
            this.forceFlush();
            this.fos.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fos != null) {
            this.fos.close();
            this.fosClosed = true;
        }
        if (this.file != null && this.deleteFileWhenClosed && this.file.exists()) {
            this.file.delete();
        }
    }
}

