/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RAFSegmentInputStream
extends InputStream {
    private RandomAccessFile raf;
    private long start;
    private long end;
    private long current;

    public RAFSegmentInputStream(RandomAccessFile raf, long start, long end) throws IOException {
        this.raf = raf;
        this.current = this.start = start;
        this.end = end;
        this.raf.seek(start);
    }

    @Override
    public int read() throws IOException {
        if (this.current >= this.end) {
            return -1;
        }
        return this.raf.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = (int)Math.min((long)len, this.end - this.current);
        if (l <= 0) {
            return -1;
        }
        l = this.raf.read(b, off, l);
        this.current += (long)l;
        return l;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.end - this.current);
    }
}

