/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.io.ReleasableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedBufferInputStream
extends ReleasableInputStream {
    private File file;
    private boolean delete;
    private FileInputStream fis;
    private FileChannel fc;
    private MappedByteBuffer mbb;

    public MappedBufferInputStream(File file, boolean delete) throws IOException {
        this(new FileInputStream(file));
        this.file = file;
        this.delete = delete;
    }

    public MappedBufferInputStream(FileInputStream fis) throws IOException {
        this(fis.getChannel());
        this.fis = fis;
    }

    public MappedBufferInputStream(FileChannel fc) throws IOException {
        this(fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size()));
        this.fc = fc;
    }

    public MappedBufferInputStream(MappedByteBuffer mbb) {
        this.mbb = mbb;
        this.mbb.mark();
    }

    @Override
    public int read() throws IOException {
        if (!this.mbb.hasRemaining()) {
            return -1;
        }
        return this.mbb.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.mbb.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.mbb.remaining());
        this.mbb.get(bytes, off, len);
        return len;
    }

    @Override
    public void reset() throws IOException {
        this.mbb.reset();
    }

    @Override
    public void close() throws IOException {
        this.closeAll();
    }

    private void closeAll() throws IOException {
        if (this.fc != null) {
            this.fc.close();
        }
        if (this.fis != null) {
            this.fis.close();
        }
    }

    @Override
    public void release() throws IOException {
        this.closeAll();
        this.unmap(this.mbb);
        this.mbb = null;
        if (this.delete && this.file != null) {
            this.file.delete();
        }
    }

    private void unmap(ByteBuffer bb) {
        try {
            Class c = bb.getClass();
            if ("DirectByteBufferR".equals(c.getSimpleName())) {
                c = (Class)c.getGenericSuperclass();
            }
            Field cf = c.getDeclaredField("cleaner");
            cf.setAccessible(true);
            Object cleaner = cf.get(bb);
            Method cm = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
            cm.setAccessible(true);
            cm.invoke(cleaner, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Can't unmap this MappedByteBuffer in " + this.getClass().getSimpleName());
        }
    }

    @Override
    public boolean inMemory() {
        return false;
    }

    public File getFile() {
        return this.file;
    }
}

