/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import java.io.IOException;
import java.io.OutputStream;

public class DoNothingOutputStream
extends OutputStream {
    private long length = 0L;
    private boolean pause = false;

    @Override
    public void write(int b) throws IOException {
        if (!this.pause) {
            ++this.length;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (!this.pause) {
            this.length += (long)len;
        }
    }

    public int getOutputLength() {
        return (int)this.length;
    }

    public void pause() {
        this.pause = true;
    }

    public void restart() {
        this.pause = false;
    }

    public void reset() {
        this.length = 0L;
    }
}

