/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.util.StringTool;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestInputStream
extends InputStream {
    private boolean pause = false;
    private byte[] digest = null;
    private MessageDigest msgd = null;
    private InputStream in = null;

    public DigestInputStream(String algorithm, InputStream os) throws NoSuchAlgorithmException {
        this.msgd = MessageDigest.getInstance(algorithm);
        this.in = os;
    }

    public DigestInputStream(String algorithm) throws NoSuchAlgorithmException {
        this.msgd = MessageDigest.getInstance(algorithm);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public void pause() {
        this.pause = true;
    }

    public void restart() {
        this.pause = false;
    }

    @Override
    public void reset() {
        if (this.msgd != null) {
            this.msgd.reset();
        }
        this.digest = null;
    }

    private void update(byte[] input, int off, int len) {
        if (this.msgd != null && !this.pause) {
            this.msgd.update(input, off, len);
        }
    }

    public byte[] getDigest() {
        this.digest = (byte[])(this.msgd != null ? this.msgd.digest() : null);
        return this.digest;
    }

    public String getDigestText() {
        byte[] hash = null;
        hash = this.digest != null ? this.digest : this.getDigest();
        if (hash == null) {
            return null;
        }
        return StringTool.bytesToHexStr(hash, false);
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r > -1) {
            this.update(new byte[]{(byte)r}, 0, 1);
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = this.in.read(b);
        if (len > 0) {
            this.update(b, 0, len);
        }
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r > 0) {
            this.update(b, off, Math.min(len, r));
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }
}

