/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountInputStream
extends FilterInputStream {
    private long count;

    public CountInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r != -1) {
            ++this.count;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int l = super.read(b);
        if (l != -1) {
            this.count += (long)l;
        }
        return l;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = super.read(b, off, len);
        if (l != -1) {
            this.count += (long)l;
        }
        return l;
    }

    public long count() {
        return this.count;
    }
}

