/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.io.ByteArrayReleaseInputStream;
import cpcns.io.ReleasableInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;

public class ComplexInputStream
extends ReleasableInputStream {
    private ByteArrayReleaseInputStream bis;
    private ReleasableInputStream ris;
    private SequenceInputStream sis;

    public ComplexInputStream(ByteArrayReleaseInputStream bb, ReleasableInputStream ra) {
        this.bis = bb;
        if (this.bis == null) {
            throw new NullPointerException("first argument must be not null!");
        }
        this.ris = ra;
        if (this.ris != null) {
            this.sis = new SequenceInputStream(this.bis, this.ris);
        }
    }

    public ComplexInputStream(byte[] bb, ReleasableInputStream ra) {
        this(bb == null ? null : new ByteArrayReleaseInputStream(bb), ra);
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        n = this.sis == null ? this.bis.read() : this.sis.read();
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        l = this.sis == null ? this.bis.read(b, off, len) : this.sis.read(b, off, len);
        return l;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.bis.reset();
        if (this.ris != null) {
            this.ris.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
        if (this.ris != null) {
            this.ris.close();
        }
    }

    @Override
    public void release() throws IOException {
        this.bis.release();
        if (this.ris != null) {
            this.ris.release();
        }
    }

    @Override
    public boolean inMemory() {
        boolean b = this.bis.inMemory();
        if (this.ris != null) {
            b = b && this.ris.inMemory();
        }
        return b;
    }
}

