/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArraySegmentInputStream
extends InputStream {
    private byte[] raf;
    private int start;
    private int end;
    private int current;

    public ByteArraySegmentInputStream(byte[] buf, long start, long end) throws IOException {
        this.raf = buf;
        this.current = this.start = (int)start;
        this.end = (int)end;
    }

    @Override
    public int read() throws IOException {
        if (this.current >= this.end) {
            return -1;
        }
        byte r = this.raf[this.current++];
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = Math.min(len, this.end - this.start);
        if (l <= 0) {
            return -1;
        }
        System.arraycopy(this.raf, this.current, b, off, l);
        this.current += l;
        return l;
    }

    @Override
    public int available() throws IOException {
        return this.end - this.current;
    }
}

