/*
 * Decompiled with CFR 0.152.
 */
package cpcns.io;

import cpcns.io.ReleasableInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ByteArrayReleaseInputStream
extends ReleasableInputStream {
    private byte[] buf;
    private ByteArrayInputStream bais;

    public ByteArrayReleaseInputStream(byte[] buf) {
        this.buf = buf;
        this.bais = new ByteArrayInputStream(buf);
        this.bais.mark(0);
    }

    @Override
    public int read() throws IOException {
        return this.bais.read();
    }

    @Override
    public void close() throws IOException {
        this.bais.close();
    }

    @Override
    public void release() throws IOException {
        this.buf = null;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.bais.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bais.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bais.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.bais.available();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.bais.reset();
    }

    public int size() {
        return this.buf.length;
    }
}

