/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http.html;

public class TextStyle {
    public static final String DEFAULT_COLOR = "#000000";
    public static final String DEFAULT_FONT_WEIGHT = "normal";
    public static final String DEFAULT_FONT_WEIGHT_INT = "400";
    public static final String DEFAULT_FONT_STYLE = "normal";
    public static final String DEFAULT_POSITION = "static";
    private String font;
    private float fontSize;
    private String fontWeight;
    private String fontStyle;
    private String color;
    private float letterSpacing;
    private String position;
    private float x;
    private float y;

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public float getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setLetterSpacing(float letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public boolean sameLine(TextStyle other) {
        if (other == null) {
            return false;
        }
        return Math.abs(this.y - other.y) < 1.0f;
    }

    public boolean canGroup(TextStyle other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.safeEquals(this.position, other.position)) {
            return false;
        }
        if (!this.safeEquals(this.color, other.color)) {
            return false;
        }
        if (!this.safeEquals(this.font, other.font)) {
            return false;
        }
        if (Float.floatToIntBits(this.fontSize) != Float.floatToIntBits(other.fontSize)) {
            return false;
        }
        if (!this.safeEquals(this.fontStyle, other.fontStyle)) {
            return false;
        }
        if (!this.safeEquals(this.fontWeight, other.fontWeight)) {
            return false;
        }
        return Float.floatToIntBits(this.letterSpacing) == Float.floatToIntBits(other.letterSpacing);
    }

    private boolean safeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public String style(boolean withLocation) {
        StringBuilder ret = new StringBuilder();
        if (withLocation) {
            ret.append(this.location());
        }
        if (this.font != null) {
            TextStyle.append(ret, "font-family", "'" + this.font + "'");
        }
        if (this.fontSize != 0.0f) {
            TextStyle.append(ret, "font-size", this.fontSize);
        }
        if (this.fontWeight != null && !"normal".equals(this.fontWeight) && !DEFAULT_FONT_WEIGHT_INT.equals(this.fontWeight)) {
            TextStyle.append(ret, "font-weight", this.fontWeight);
        }
        if (this.fontStyle != null && !"normal".equals(this.fontStyle)) {
            TextStyle.append(ret, "font-style", this.fontStyle);
        }
        if (this.letterSpacing != 0.0f) {
            TextStyle.append(ret, "letter-spacing", this.letterSpacing);
        }
        if (this.color != null && !DEFAULT_COLOR.equals(this.color)) {
            TextStyle.append(ret, "color", this.color);
        }
        return ret.toString();
    }

    public String location() {
        StringBuilder ret = new StringBuilder();
        if (this.position != null && !DEFAULT_POSITION.equals(this.position)) {
            TextStyle.append(ret, "position", this.position);
        }
        ret.append(TextStyle.location(this.x, this.y));
        return ret.toString();
    }

    public static String location(float x, float y) {
        StringBuilder ret = new StringBuilder();
        TextStyle.append(ret, "left", x);
        TextStyle.append(ret, "top", y);
        return ret.toString();
    }

    public static String size(float w, float h) {
        StringBuilder ret = new StringBuilder();
        TextStyle.append(ret, "width", w);
        TextStyle.append(ret, "height", h);
        return ret.toString();
    }

    private static void append(StringBuilder s, String propertyName, String value) {
        if (s.length() > 0) {
            s.append(' ');
        }
        s.append(propertyName);
        s.append(':');
        s.append(value);
        s.append(';');
    }

    private static void append(StringBuilder s, String propertyName, float value) {
        if (s.length() > 0) {
            s.append(' ');
        }
        s.append(propertyName);
        s.append(':');
        s.append(TextStyle.format(value));
        s.append(';');
    }

    public static String format(float length) {
        return Math.round(length) + "px";
    }
}

