/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http.html;

import cpcns.http.html.BaseDOM;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Node
extends BaseDOM {
    private static final long serialVersionUID = -6457484874415134920L;
    private Map<String, String> attributes;
    private List<Node> children;
    private String tag;

    protected Node(String tag) {
        this.tag = tag;
    }

    public Node attribute(String name, String value) {
        if (name == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public Node id(String id) {
        return this.attribute("id", id);
    }

    public Node name(String name) {
        return this.attribute("name", name);
    }

    public Node clazz(String name) {
        return this.attribute("class", name);
    }

    public Node style(String value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        String v = value;
        if (this.attributes != null && this.attributes.containsKey("style")) {
            v = this.attributes.get("style");
            v = v + ";" + value;
        }
        return this.attribute("style", v);
    }

    public Node append(Node node) {
        if (node == null) {
            return this;
        }
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(node);
        node.parent = this;
        return this;
    }

    @Override
    public void write(Writer writer, int level) throws IOException {
        boolean hasChild;
        this.tab(writer, level).write("<" + this.tag);
        if (this.attributes != null) {
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                writer.write(" ");
                writer.write(attr.getKey());
                String v = attr.getValue();
                if (v == null || v.equals("")) continue;
                writer.write("=\"");
                writer.write(v);
                writer.write("\"");
            }
        }
        boolean bl = hasChild = this.children != null && !this.children.isEmpty();
        if (!hasChild) {
            writer.write(" /");
        }
        writer.write(">");
        if (hasChild) {
            this.newLine(writer);
            for (Node n : this.children) {
                n.write(writer, level + 1);
            }
            this.line(writer, level, "</" + this.tag + ">");
        } else {
            this.newLine(writer);
        }
    }

    public static Node div() {
        return new Node("div");
    }

    public static Node a() {
        return new Node("a");
    }

    public static Node span() {
        return new Node("span");
    }

    public static Node p() {
        return new Node("p");
    }

    public static Node img() {
        return new Node("img");
    }

    public static Node table() {
        return new Node("table");
    }

    public static Node newDOM(String tag) {
        return new Node(tag);
    }
}

