/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http.html;

import cpcns.http.html.Node;
import cpcns.http.html.Text;
import cpcns.http.html.TextStyle;
import cpcns.util.IOUtils;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class HTMLGraphics
extends Graphics2D {
    private Node div;
    private BufferedImage image;
    private Graphics2D ig2d;
    private Color fontColor;
    private TextListener listener;
    private boolean genHTML;
    private List<Node> group;
    private TextStyle lastStyle;

    public HTMLGraphics(Node div, int width, int height) {
        this.div = div;
        this.image = new BufferedImage(width, height, 1);
        this.ig2d = this.image.createGraphics();
        this.genHTML = this.div != null;
    }

    public void saveImage(OutputStream os, String type) throws IOException {
        try {
            ImageIO.write((RenderedImage)this.image, type, os);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    public Node content() {
        return this.div;
    }

    public void finish() {
        this.flushGroup();
    }

    public void setTextListener(TextListener tl) {
        this.listener = tl;
    }

    @Override
    public void draw(Shape s) {
        this.ig2d.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.ig2d.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.ig2d.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.ig2d.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.ig2d.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.ig2d.drawString(str, x, y);
        if (this.genHTML) {
            this.drawText(str, x, y, this.getFont());
        }
    }

    private void drawText(String text, float x, float y, Font font) {
        double xs = 1.0;
        double ys = 1.0;
        AffineTransform at = this.getTransform();
        if (at != null) {
            float[] p0 = new float[]{x, y};
            float[] p1 = new float[2];
            at.transform(p0, 0, p1, 0, 1);
            x = p1[0];
            y = p1[1];
            xs = at.getScaleX();
            ys = at.getScaleY();
        }
        float zoom = 100.0f;
        if (font != null) {
            if (Math.abs(ys - 1.0) > (double)0.1f) {
                font = font.deriveFont((float)((double)font.getSize2D() * ys * (double)zoom));
            }
            FontMetrics fm = this.getFontMetrics(font);
            int ascent = fm.getAscent();
            y = (y * zoom - (float)ascent) / zoom;
        }
        TextStyle style = new TextStyle();
        style.setLocation(x, y);
        if (font != null) {
            double d;
            style.setFont(font.getName());
            float size = font.getSize2D() / zoom;
            style.setFontSize(size);
            if (font.isBold()) {
                style.setFontWeight("bold");
            }
            if (font.isItalic()) {
                style.setFontStyle("italic");
            }
            if (Math.abs((d = xs / ys) - 1.0) > (double)0.1f) {
                // empty if block
            }
        }
        Node node = Node.span();
        if (this.listener != null) {
            this.listener.before(node);
        }
        node.style(style.location());
        node.append(new Text(text));
        if (this.listener != null) {
            this.listener.after(node);
        }
        if (this.group == null) {
            this.group = new ArrayList<Node>();
        }
        if (this.lastStyle == null) {
            this.lastStyle = style;
        }
        if (this.lastStyle.canGroup(style)) {
            this.group.add(node);
        } else {
            this.flushGroup();
            this.group.add(node);
            this.lastStyle = style;
        }
    }

    private void flushGroup() {
        if (this.group == null || this.group.isEmpty()) {
            return;
        }
        Node g = Node.div();
        g.clazz("group");
        g.style(this.lastStyle.style(false));
        for (Node n : this.group) {
            g.append(n);
        }
        this.div.append(g);
        this.group.clear();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.ig2d.drawString(iterator, x, y);
        if (this.genHTML) {
            Font font = this.getFont();
            StringBuilder sb = new StringBuilder(iterator.getEndIndex());
            char c = iterator.first();
            while (c != '\uffff') {
                if (iterator.getIndex() == iterator.getRunStart()) {
                    if (sb.length() > 0) {
                        this.drawString(sb.toString(), x, y);
                        FontMetrics fm = this.getFontMetrics();
                        x = (float)((double)x + fm.getStringBounds(sb.toString(), this).getWidth());
                        sb.delete(0, sb.length());
                    }
                    font = this.doAttributes(iterator, font);
                }
                sb.append(c);
                c = iterator.next();
            }
            this.drawText(sb.toString(), x, y, font);
        }
    }

    private Font doAttributes(AttributedCharacterIterator aci, Font font) {
        Map<AttributedCharacterIterator.Attribute, Object> attrs = aci.getAttributes();
        for (AttributedCharacterIterator.Attribute attribute : attrs.keySet()) {
            Map<TextAttribute, ?> fa;
            if (!(attribute instanceof TextAttribute)) continue;
            TextAttribute ta = (TextAttribute)attribute;
            if (ta.equals(TextAttribute.FONT)) {
                font = (Font)attrs.get(ta);
                continue;
            }
            if (ta.equals(TextAttribute.SIZE)) {
                Object obj = attrs.get(ta);
                if (!(obj instanceof Number)) continue;
                float f = ((Number)obj).floatValue();
                font = font.deriveFont(f);
                continue;
            }
            if (ta.equals(TextAttribute.FOREGROUND)) {
                this.fontColor = (Color)attrs.get(ta);
                continue;
            }
            if (ta.equals(TextAttribute.FAMILY)) {
                fa = font.getAttributes();
                fa.put(TextAttribute.FAMILY, attrs.get(ta));
                font = font.deriveFont(fa);
                continue;
            }
            if (ta.equals(TextAttribute.POSTURE)) {
                fa = font.getAttributes();
                fa.put(TextAttribute.POSTURE, attrs.get(ta));
                font = font.deriveFont(fa);
                continue;
            }
            if (!ta.equals(TextAttribute.WEIGHT)) continue;
            fa = font.getAttributes();
            fa.put(TextAttribute.WEIGHT, attrs.get(ta));
            font = font.deriveFont(fa);
        }
        return font;
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.ig2d.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.ig2d.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.ig2d.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.ig2d.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.ig2d.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.ig2d.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.ig2d.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.ig2d.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.ig2d.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.ig2d.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.ig2d.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.ig2d.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.ig2d.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.ig2d.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.ig2d.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.ig2d.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.ig2d.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.ig2d.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.ig2d.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.ig2d.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.ig2d.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.ig2d.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.ig2d.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.ig2d.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.ig2d.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.ig2d.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.ig2d.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.ig2d.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return this.ig2d.create();
    }

    @Override
    public Color getColor() {
        return this.ig2d.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.ig2d.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.ig2d.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.ig2d.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.ig2d.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.ig2d.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.ig2d.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.ig2d.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.ig2d.clearRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.ig2d.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.ig2d.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.ig2d.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.ig2d.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.ig2d.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.ig2d.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.ig2d.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.ig2d.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.ig2d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.ig2d.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.ig2d.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.ig2d.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.ig2d.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.ig2d.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.ig2d.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.ig2d.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.ig2d.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.ig2d.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.ig2d.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.ig2d.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.ig2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.ig2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
        this.ig2d.dispose();
        this.flushGroup();
    }

    public static interface TextListener {
        public void before(Node var1);

        public void after(Node var1);
    }
}

