/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http.html;

import cpcns.http.html.BaseDOM;
import cpcns.http.html.Body;
import cpcns.http.html.Head;
import cpcns.http.html.Node;
import cpcns.http.html.Text;
import cpcns.io.UnclosedOutputStream;
import cpcns.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class HTML
extends BaseDOM {
    private static final long serialVersionUID = -5430888979515673459L;
    private Head head = new Head(this);
    private Body body = new Body(this);

    public Head head() {
        return this.head;
    }

    public Body body() {
        return this.body;
    }

    @Override
    protected void write(Writer writer, int level) throws IOException {
        try {
            this.line(writer, level, "<!DOCTYPE html>");
            this.line(writer, level, "<html lang=\"zh-CN\">");
            this.head.write(writer, level + 1);
            this.body.write(writer, level + 1);
            this.tab(writer, level).write("</html>");
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, 0);
    }

    public void write(OutputStream os) throws IOException {
        this.write(new OutputStreamWriter(os, "UTF-8"));
    }

    public void write(File file) throws IOException {
        this.write(new OutputStreamWriter((OutputStream)FileUtils.openOutputStream(file), "UTF-8"));
    }

    public static void main(String[] args) throws IOException {
        HTML html = new HTML();
        html.head.title("Hello");
        html.head.meta("hello", "world");
        html.body.attribute("class", "body");
        Node div = Node.div();
        html.body.append(div);
        div.append(new Text("World"));
        try {
            html.write(new UnclosedOutputStream(System.out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        try {
            HTML nh = (HTML)html.clone();
            nh.head.title("****************");
            nh.write(new UnclosedOutputStream(System.out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

