/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http;

import cpcns.http.CharsetTools;
import cpcns.http.HttpBase;
import cpcns.http.HttpMethod;
import cpcns.http.HttpRequest;
import cpcns.http.HttpStatusException;
import cpcns.http.KeyVal;
import cpcns.http.TokenQueue;
import cpcns.http.Validate;
import cpcns.io.ByteArrayReleaseInputStream;
import cpcns.io.RandomAccessFileInputStream;
import cpcns.io.ReleasableInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;

public class HttpResponse
extends HttpBase<HttpResponse> {
    private static final long MAX_MEMORY_CACHE = 0xA00000L;
    private static final int MAX_REDIRECTS = 20;
    private int statusCode;
    private String statusMessage;
    private byte[] byteData;
    private File cacheFile;
    private String charset;
    private String contentType;
    private boolean executed = false;
    private int numRedirects = 0;
    private String boundary = "----Boundary" + HttpResponse.randomUnique(16);
    private static final char[] SEEDS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    static String randomUnique(int length) {
        HashSet<Character> set = new HashSet<Character>();
        Random r = new Random();
        int l = SEEDS.length;
        if (length > l) {
            length = l;
        }
        for (int i = 0; i < length; ++i) {
            char c = SEEDS[r.nextInt(l)];
            while (!set.add(Character.valueOf(c))) {
                c = SEEDS[r.nextInt(l)];
            }
        }
        char[] c = new char[length];
        int i = 0;
        for (Character ch : set) {
            c[i++] = ch.charValue();
        }
        return new String(c);
    }

    static String random(int length) {
        Random r = new Random();
        int l = SEEDS.length;
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = SEEDS[r.nextInt(l)];
        }
        return new String(c);
    }

    HttpResponse() {
    }

    private HttpResponse(HttpResponse previousResponse) throws IOException {
        this();
        if (previousResponse != null) {
            this.numRedirects = previousResponse.numRedirects + 1;
            if (this.numRedirects >= 20) {
                throw new IOException(String.format("Too many redirects occurred trying to load URL %s", previousResponse.url()));
            }
        }
    }

    HttpResponse execute(HttpRequest req) throws IOException {
        return this.execute(req, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpResponse execute(HttpRequest req, HttpResponse previousResponse) throws IOException {
        HttpResponse res;
        Validate.notNull(req, "Request must not be null");
        String protocol = req.url().getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new MalformedURLException("Only http & https protocols supported");
        }
        if ((req.method() == HttpMethod.GET || req.method() == HttpMethod.HEAD) && req.data().size() > 0) {
            HttpResponse.serialiseRequestUrl(req);
        }
        HttpURLConnection conn = this.createConnection(req);
        try {
            if (req.method() == HttpMethod.UPLOAD) {
                Collection<KeyVal> data = req.data();
                for (KeyVal kv : data) {
                    Object v = kv.value();
                    if (!(v instanceof File) && !(v instanceof InputStream)) continue;
                    conn.setChunkedStreamingMode(0x200000);
                    break;
                }
            }
            conn.connect();
            if (req.method() == HttpMethod.POST) {
                this.writePost(req.data(), conn.getOutputStream());
            } else if (req.method() == HttpMethod.UPLOAD) {
                this.writeUpload(req.data(), conn.getOutputStream());
            }
            int status = conn.getResponseCode();
            boolean needsRedirect = false;
            if (status != 200) {
                if (status == 302 || status == 301 || status == 303) {
                    needsRedirect = true;
                } else if (!req.ignoreHttpErrors()) {
                    throw new HttpStatusException("HTTP error fetching URL", status, req.url().toString());
                }
            }
            res = new HttpResponse(previousResponse);
            res.setupFromConnection(conn, previousResponse);
            res.cacheFile = req.cache();
            if (needsRedirect && req.followRedirects()) {
                req.method(HttpMethod.GET);
                req.data().clear();
                req.url(new URL(req.url(), res.header("Location")));
                for (Map.Entry cookie : res.cookies.entrySet()) {
                    req.cookie((String)cookie.getKey(), (String)cookie.getValue());
                }
                HttpResponse httpResponse = this.execute(req, res);
                return httpResponse;
            }
            if (req.method() != HttpMethod.HEAD) {
                this.receive(conn, res);
            }
            res.charset = CharsetTools.getCharsetFromContentType(res.contentType);
        }
        finally {
            conn.disconnect();
        }
        res.executed = true;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(HttpURLConnection conn, HttpResponse res) throws IOException {
        InputStream body = null;
        InputStream ds = null;
        try {
            ds = conn.getErrorStream();
            if (ds == null) {
                ds = conn.getInputStream();
            }
            InputStream inputStream = body = res.hasHeader("Content-Encoding") && res.header("Content-Encoding").equalsIgnoreCase("gzip") ? new BufferedInputStream(new GZIPInputStream(ds)) : new BufferedInputStream(ds);
            if (res.cacheFile != null) {
                HttpResponse.saveTo(body, res.cacheFile, false);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] b = new byte[8192];
                int length = -1;
                long total = 0L;
                while ((length = body.read(b)) != -1) {
                    baos.write(b, 0, length);
                    if ((total += (long)length) <= 0xA00000L) continue;
                    File file = File.createTempFile("http_cache_", ".dat");
                    HttpResponse.saveTo(new ByteArrayInputStream(baos.toByteArray()), file, false);
                    HttpResponse.saveTo(body, file, true);
                    res.cacheFile = file;
                    return;
                }
                byte[] buf = baos.toByteArray();
                if (buf != null) {
                    res.byteData = buf;
                }
            }
        }
        finally {
            if (body != null) {
                body.close();
            }
            if (ds != null) {
                ds.close();
            }
        }
    }

    private void writeUpload(Collection<KeyVal> data, OutputStream outputStream) throws IOException {
        DataOutputStream out = new DataOutputStream(outputStream);
        for (KeyVal kv : data) {
            String name = kv.key();
            Object val = kv.value();
            if (val instanceof File) {
                File f = (File)val;
                this.writeDataBody(out, name, f.getName(), new FileInputStream(f));
                continue;
            }
            if (val instanceof byte[]) {
                byte[] b = (byte[])val;
                this.writeDataBody(out, name, String.valueOf(b.hashCode()), new ByteArrayInputStream(b));
                continue;
            }
            if (val instanceof InputStream) {
                InputStream i = (InputStream)val;
                this.writeDataBody(out, name, String.valueOf(i.hashCode()), i);
                continue;
            }
            String s = String.valueOf(val);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(this.boundary);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"" + name + "\"\r\n\r\n");
            byte[] b = sb.toString().getBytes("UTF-8");
            ((OutputStream)out).write(b);
            ((OutputStream)out).write(s.getBytes("UTF-8"));
            ((OutputStream)out).write("\r\n".getBytes());
        }
        byte[] end = ("\r\n--" + this.boundary + "--\r\n").getBytes();
        ((OutputStream)out).write(end);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataBody(OutputStream out, String name, String fileName, InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("--");
        sb.append(this.boundary);
        sb.append("\r\n");
        sb.append("Content-Disposition: form-data;name=\"" + name + "\";filename=\"" + fileName + "\"\r\n");
        sb.append("Content-Type:application/octet-stream\r\n\r\n");
        byte[] b = sb.toString().getBytes("UTF-8");
        out.write(b);
        DataInputStream in = null;
        try {
            in = new DataInputStream(is);
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                out.write(bufferOut, 0, bytes);
            }
            out.write("\r\n".getBytes());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String charset() {
        return this.charset;
    }

    public String contentType() {
        return this.contentType;
    }

    public String bodyAsText() throws IOException {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        if (this.byteData == null) {
            return null;
        }
        String body = this.charset == null ? new String(this.byteData, Charset.forName("UTF-8")) : new String(this.byteData, Charset.forName(this.charset));
        return body;
    }

    public ReleasableInputStream bodyAsStream() throws IOException {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        if (this.cacheFile != null) {
            return new RandomAccessFileInputStream(this.cacheFile);
        }
        if (this.byteData != null) {
            return new ByteArrayReleaseInputStream(this.byteData);
        }
        return null;
    }

    public File bodyAsFile() throws IOException {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        if (this.cacheFile != null) {
            return this.cacheFile;
        }
        if (this.byteData != null) {
            File file = File.createTempFile("http_cache_", ".dat");
            HttpResponse.saveByteToFile(this.byteData, file);
            this.cacheFile = file;
            return this.cacheFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveByteToFile(byte[] b, File file) {
        if (b == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(b);
            fos.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object body() throws IOException {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        if (this.cacheFile != null) {
            return this.cacheFile;
        }
        if (this.contentType != null && this.contentType.contains("stream") && this.byteData != null) {
            return new ByteArrayReleaseInputStream(this.byteData);
        }
        return this.bodyAsText();
    }

    private HttpURLConnection createConnection(HttpRequest req) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)req.url().openConnection();
        HttpMethod m = req.method();
        if (m == HttpMethod.UPLOAD) {
            m = HttpMethod.POST;
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        }
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestMethod(m.toString());
        conn.setInstanceFollowRedirects(false);
        conn.setConnectTimeout(req.timeout());
        conn.setReadTimeout(req.timeout());
        if (m == HttpMethod.POST) {
            conn.setDoOutput(true);
        }
        if (req.cookies().size() > 0) {
            conn.addRequestProperty("Cookie", HttpResponse.getRequestCookieString(req));
        }
        for (Map.Entry header : req.headers().entrySet()) {
            conn.addRequestProperty((String)header.getKey(), (String)header.getValue());
        }
        return conn;
    }

    private void setupFromConnection(HttpURLConnection conn, HttpResponse previousResponse) throws IOException {
        this.method = HttpMethod.valueOf(conn.getRequestMethod());
        this.url = conn.getURL();
        this.statusCode = conn.getResponseCode();
        this.statusMessage = conn.getResponseMessage();
        this.contentType = conn.getContentType();
        Map<String, List<String>> resHeaders = conn.getHeaderFields();
        this.processResponseHeaders(resHeaders);
        if (previousResponse != null) {
            for (Map.Entry prevCookie : previousResponse.cookies().entrySet()) {
                if (this.hasCookie((String)prevCookie.getKey())) continue;
                this.cookie((String)prevCookie.getKey(), (String)prevCookie.getValue());
            }
        }
    }

    void processResponseHeaders(Map<String, List<String>> resHeaders) {
        for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            List<String> values = entry.getValue();
            if (name.equalsIgnoreCase("Set-Cookie")) {
                for (String value : values) {
                    if (value == null) continue;
                    TokenQueue cd = new TokenQueue(value);
                    String cookieName = cd.chompTo("=").trim();
                    String cookieVal = cd.consumeTo(";").trim();
                    if (cookieVal == null) {
                        cookieVal = "";
                    }
                    if (cookieName == null || cookieName.length() <= 0) continue;
                    this.cookie(cookieName, cookieVal);
                }
                continue;
            }
            if (values.isEmpty()) continue;
            this.header(name, values.get(0));
        }
    }

    private void writePost(Collection<KeyVal> data, OutputStream outputStream) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(outputStream, "UTF-8");
        boolean first = true;
        for (KeyVal keyVal : data) {
            if (!first) {
                w.append('&');
            } else {
                first = false;
            }
            w.write(URLEncoder.encode(keyVal.key(), "UTF-8"));
            w.write(61);
            w.write(URLEncoder.encode(String.valueOf(keyVal.value()), "UTF-8"));
        }
        w.close();
    }

    private static String getRequestCookieString(HttpRequest req) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry cookie : req.cookies().entrySet()) {
            if (!first) {
                sb.append("; ");
            } else {
                first = false;
            }
            sb.append((String)cookie.getKey()).append('=').append((String)cookie.getValue());
        }
        return sb.toString();
    }

    private static void serialiseRequestUrl(HttpRequest req) throws IOException {
        URL in = req.url();
        StringBuilder url = new StringBuilder();
        boolean first = true;
        url.append(in.getProtocol()).append("://").append(in.getAuthority()).append(in.getPath()).append("?");
        if (in.getQuery() != null) {
            url.append(in.getQuery());
            first = false;
        }
        for (KeyVal keyVal : req.data()) {
            if (!first) {
                url.append('&');
            } else {
                first = false;
            }
            url.append(URLEncoder.encode(keyVal.key(), "UTF-8")).append('=').append(URLEncoder.encode(String.valueOf(keyVal.value()), "UTF-8"));
        }
        req.url(new URL(url.toString()));
        req.data().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveTo(InputStream is, File file, boolean append) throws IOException {
        OutputStream os = null;
        byte[] b = new byte[5120];
        int l = -1;
        try {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            while ((l = is.read(b)) != -1) {
                os.write(b, 0, l);
            }
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

