/*
 * Decompiled with CFR 0.152.
 */
package cpcns.http;

import cpcns.http.HttpBase;
import cpcns.http.HttpMethod;
import cpcns.http.KeyVal;
import cpcns.http.Validate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private int timeoutMilliseconds = 3000;
    private boolean followRedirects = true;
    private Collection<KeyVal> data = new ArrayList<KeyVal>();
    private boolean ignoreHttpErrors = false;
    private File cache;

    HttpRequest() {
        this.method = HttpMethod.GET;
        this.headers.put("Accept-Encoding", "gzip");
    }

    public HttpRequest cache(File file) {
        this.cache = file;
        return this;
    }

    public File cache() {
        return this.cache;
    }

    public int timeout() {
        return this.timeoutMilliseconds;
    }

    public HttpRequest timeout(int millis) {
        Validate.isTrue(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
        this.timeoutMilliseconds = millis;
        return this;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean ignoreHttpErrors() {
        return this.ignoreHttpErrors;
    }

    public HttpRequest ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.ignoreHttpErrors = ignoreHttpErrors;
        return this;
    }

    public HttpRequest data(KeyVal keyval) {
        Validate.notNull(keyval, "Key val must not be null");
        this.data.add(keyval);
        return this;
    }

    public Collection<KeyVal> data() {
        return this.data;
    }
}

