/*
 * Decompiled with CFR 0.152.
 */
package cpcns.detect.impl;

import cpcns.util.XMLVisitor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ZipContainerDetector
implements Detector {
    private static final long serialVersionUID = 2891763938430295453L;
    private static final int[] PK = new int[]{80, 75, 3, 4};

    public static boolean isZipArchive(byte[] b) {
        for (int i = 0; i < PK.length; ++i) {
            if ((b[i] & 0xFF) == PK[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        input.mark(1024);
        try {
            byte[] prefix = new byte[4];
            int len = input.read(prefix);
            if (len == prefix.length && ZipContainerDetector.isZipArchive(prefix)) {
                input.reset();
                MediaType mediaType = ZipContainerDetector.detectZipFormat(input);
                return mediaType;
            }
            MediaType mediaType = MediaType.OCTET_STREAM;
            return mediaType;
        }
        finally {
            try {
                input.reset();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Exception decompiling
     */
    private static MediaType detectZipFormat(InputStream input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MediaType detectOpenXML(ZipFile zip) {
        try {
            if (zip.getEntry("EncryptionInfo") != null && zip.getEntry("EncryptedPackage") != null) {
                return MediaType.application((String)"office-encrypted");
            }
            if (zip.getEntry("_rels/.rels") != null || zip.getEntry("[Content_Types].xml") != null) {
                ZipArchiveEntry rel = zip.getEntry("_rels/.rels");
                InputStream ris = zip.getInputStream(rel);
                Document doc = XMLVisitor.parse(ris, true);
                List<Element> list = XMLVisitor.children(doc.getDocumentElement());
                for (Element e : list) {
                    String type = e.getAttribute("Type");
                    if (type.equals("http://schemas.microsoft.com/xps/2005/06/fixedrepresentation")) {
                        return MediaType.application((String)"xps");
                    }
                    if (type.equals("http://schemas.autodesk.com/dwfx/2007/relationships/documentsequence")) {
                        return MediaType.application((String)"dwfx");
                    }
                    if (type.equals("http://schemas.microsoft.com/visio/2010/relationships/document")) {
                        return MediaType.application((String)"vsd");
                    }
                    if (!type.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument") && !type.equals("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument")) continue;
                    return ZipContainerDetector.detectCotentXML(zip, e.getAttribute("Target"));
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MediaType detectCotentXML(ZipFile zip, String target) {
        try {
            ZipArchiveEntry zae = zip.getEntry("[Content_Types].xml");
            InputStream cis = zip.getInputStream(zae);
            Document doc = XMLVisitor.parse(cis, true);
            List<Element> list = XMLVisitor.listByXPath(doc.getDocumentElement(), "Override");
            String appName = null;
            String mediaType = null;
            for (Element e : list) {
                String partName = e.getAttribute("PartName");
                String type = e.getAttribute("ContentType");
                if (type.contains("extended-properties")) {
                    Document epd;
                    Element app;
                    ZipArchiveEntry ep;
                    String name = partName;
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if ((ep = zip.getEntry(name)) != null && (app = XMLVisitor.findByXPath((epd = XMLVisitor.parse(zip.getInputStream(ep), true)).getDocumentElement(), "Application")) != null) {
                        appName = app.getTextContent().toLowerCase();
                    }
                }
                if (!partName.endsWith(target)) continue;
                if (type.contains("wordprocessing") || type.contains("word")) {
                    mediaType = "docx";
                }
                if (type.contains("spreadsheet") || type.contains("excel")) {
                    mediaType = "xlsx";
                }
                if (!type.contains("presentation") && !type.contains("powerpoint")) continue;
                mediaType = "pptx";
            }
            if (appName != null) {
                if (appName.contains("wps") || appName.contains("kso")) {
                    mediaType = "ks+" + mediaType;
                } else if (appName.contains("microsoft")) {
                    mediaType = "ms+" + mediaType;
                }
            }
            return MediaType.application(mediaType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MediaType detectJar(ZipFile zip) {
        if (zip.getEntry("META-INF/MANIFEST.MF") != null) {
            if (zip.getEntry("AndroidManifest.xml") != null) {
                return MediaType.application((String)"apk");
            }
            if (zip.getEntry("WEB-INF/") != null) {
                return MediaType.application((String)"war");
            }
            if (zip.getEntry("META-INF/application.xml") != null) {
                return MediaType.application((String)"ear");
            }
            return MediaType.application((String)"jar");
        }
        if (zip.getEntry("AndroidManifest.xml") != null) {
            return MediaType.application((String)"apk");
        }
        return null;
    }
}

