/*
 * Decompiled with CFR 0.152.
 */
package cpcns.detect;

import cpcns.detect.impl.ZipContainerDetector;
import cpcns.io.RandomAccessFileInputStream;
import cpcns.io.ReleasableInputStream;
import cpcns.util.CacheManager;
import cpcns.util.IOUtils;
import cpcns.util.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class Detectors {
    private static Tika tika;
    private static CacheManager<Info> cache;
    private static InfoLoader loader;
    private static final String[] OFFICE;

    public static boolean isImage(File file) {
        try {
            String type = Detectors.detect(file);
            if (type == null) {
                return false;
            }
            String preffix = type.substring(0, type.indexOf("/"));
            return "image".equals(preffix);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZip(File file) {
        boolean bl;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] b = StreamUtils.read(is, 4);
            bl = ZipContainerDetector.isZipArchive(b);
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
            return bl2;
        }
        IOUtils.closeQuietly(is);
        return bl;
    }

    public static boolean isOFD(File file) {
        try {
            return "ofd".equals(Detectors.suffix(file));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isXPS(File file) {
        try {
            return "xps".equals(Detectors.suffix(file));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPDF(File file) {
        try {
            return "pdf".equals(Detectors.suffix(file));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSourcePackage(File file) {
        try {
            return "x-source-pkg".equals(Detectors.suffix(file));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Office isOffice(File file, String format) throws Exception {
        boolean isOffice = false;
        if (format != null) {
            for (String s : OFFICE) {
                if (!format.contains(s)) continue;
                isOffice = true;
                break;
            }
        }
        String suffix = null;
        if (isOffice || format == null) {
            suffix = Detectors.suffix(file);
        }
        if (suffix == null) {
            return null;
        }
        isOffice = false;
        for (String s : OFFICE) {
            if (!suffix.contains(s)) continue;
            isOffice = true;
            break;
        }
        if (isOffice) {
            String app;
            int appType = 1;
            int index = suffix.indexOf("+");
            if (index != -1 && "ks".equals(app = suffix.substring(0, index))) {
                appType = 2;
            }
            return new Office(suffix.contains("encrypt"), appType, suffix);
        }
        return null;
    }

    public static String suffix(File file) throws Exception {
        String mime = Detectors.detect(file);
        if (mime == null) {
            return null;
        }
        if (mime.equals(MediaType.OCTET_STREAM.toString())) {
            return null;
        }
        if (mime.equals("text/plain")) {
            return "txt";
        }
        return mime.substring(mime.indexOf("/") + 1);
    }

    public static String detect(InputStream is) throws IOException {
        if (is instanceof ReleasableInputStream) {
            return Detectors.detect((ReleasableInputStream)is, null);
        }
        ReleasableInputStream ris = StreamUtils.duplicate(is, 0x100000L);
        try {
            String string = Detectors.detect(ris, null);
            return string;
        }
        finally {
            ris.release();
        }
    }

    public static String detect(File file) throws Exception {
        if (file == null || !file.exists()) {
            return null;
        }
        String path = file.getAbsolutePath();
        Info info = cache.get(path, loader);
        if (info.same(file)) {
            return info.type;
        }
        info = loader.load(path);
        cache.cache(path, info);
        return info.type;
    }

    private static String _detect(File file) throws IOException {
        RandomAccessFileInputStream ris = null;
        try {
            ris = new RandomAccessFileInputStream(file, false);
            String string = Detectors.detect(ris, file.getName());
            return string;
        }
        finally {
            if (ris != null) {
                ((ReleasableInputStream)ris).release();
            }
        }
    }

    public static String detect(URL url) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
            String string = Detectors.detect(is);
            return string;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private static String detect(ReleasableInputStream ris, String name) throws IOException {
        Metadata m = new Metadata();
        if (name != null) {
            m.add("resourceName", name);
        }
        return tika.detect((InputStream)ris, m);
    }

    static {
        OFFICE = new String[]{"doc", "xls", "ppt", "vsd", "office"};
        try {
            TikaConfig config = new TikaConfig(Detectors.class.getResource("config.xml"));
            tika = new Tika(config);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cache = CacheManager.newMgr(200);
        loader = new InfoLoader();
    }

    private static class Info {
        private String type;
        private long length;
        private long modify;

        private Info() {
        }

        public static Info from(File file) {
            Info info = new Info();
            info.length = file.length();
            info.modify = file.lastModified();
            return info;
        }

        public boolean same(File file) {
            return this.length == file.length() && this.modify == file.lastModified();
        }
    }

    private static class InfoLoader
    implements CacheManager.ItemLoader<Info> {
        private InfoLoader() {
        }

        @Override
        public Info load(String key) throws Exception {
            File file = new File(key);
            Info info = Info.from(file);
            info.type = Detectors._detect(file);
            return info;
        }
    }

    public static class Office {
        public static final int APP_MicroSoft = 1;
        public static final int APP_KingSoft = 2;
        public final boolean isEncrypted;
        public final int application;
        public final String format;

        private Office(boolean isEncrypted, int application, String format) {
            this.isEncrypted = isEncrypted;
            this.application = application;
            this.format = format;
        }

        public String appName() {
            switch (this.application) {
                case 2: {
                    return "kingsoft";
                }
            }
            return "microsoft";
        }

        public String curtFormat() {
            int index = this.format.indexOf("+");
            String cf = this.format;
            if (index != -1) {
                cf = cf.substring(index + 1);
            }
            if ((index = cf.indexOf("-")) != -1) {
                cf = cf.substring(0, index);
            }
            return cf;
        }

        public String toString() {
            return "Office{isEncrypted=" + this.isEncrypted + ", application=" + this.appName() + ", format='" + this.curtFormat() + '\'' + '}';
        }
    }
}

