/*
 * Decompiled with CFR 0.152.
 */
package cpcns.defs;

import cpcns.defs.IMargin;
import cpcns.defs.IRectangle;
import cpcns.defs.IRectangleWithInsets;
import cpcns.defs.Margin;
import cpcns.defs.RectangleF;
import cpcns.util.StringTool;

public class RectangleFWithInsets
extends RectangleF
implements IRectangleWithInsets,
Cloneable {
    private float leftInset = 0.0f;
    private float rightInset = 0.0f;
    private float bottomInset = 0.0f;
    private float topInset = 0.0f;

    public RectangleFWithInsets(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    @Override
    public float getBottomInset() {
        return this.bottomInset;
    }

    @Override
    public IMargin getInsets(IMargin inset) {
        if (inset == null) {
            return new Margin((int)this.topInset, (int)this.leftInset, (int)this.bottomInset, (int)this.rightInset);
        }
        inset.setLeft(this.leftInset);
        inset.setTop(this.topInset);
        inset.setBottom(this.bottomInset);
        inset.setRight(this.rightInset);
        return inset;
    }

    @Override
    public void setInsets(IMargin inset) {
        this.leftInset = inset.getLeft();
        this.topInset = inset.getTop();
        this.bottomInset = inset.getBottom();
        this.rightInset = inset.getRight();
    }

    @Override
    public float getLeftInset() {
        return this.leftInset;
    }

    @Override
    public void setLeftInset(float leftInset) {
        this.leftInset = leftInset;
    }

    @Override
    public float getRightInset() {
        return this.rightInset;
    }

    @Override
    public void setRightInset(float rightInset) {
        this.rightInset = rightInset;
    }

    @Override
    public float getTopInset() {
        return this.topInset;
    }

    @Override
    public void setTopInset(float topInset) {
        this.topInset = topInset;
    }

    @Override
    public void setBottomInset(float bottomInset) {
        this.bottomInset = bottomInset;
    }

    @Override
    public float getWidthAfterInset() {
        return this.getWidth() - this.rightInset - this.leftInset;
    }

    @Override
    public float getHeightAfterInset() {
        return this.getHeight() - this.topInset - this.bottomInset;
    }

    @Override
    public float getBottomAfterInset() {
        return this.getBottom() - this.getBottomInset();
    }

    @Override
    public float getLeftAfterInset() {
        return this.getLeft() + this.getLeftInset();
    }

    @Override
    public IRectangle getRectAfterInset() {
        return new RectangleF(this.getLeftAfterInset(), this.getTopAfterInset(), this.getWidthAfterInset(), this.getHeightAfterInset());
    }

    @Override
    public float getRightAfterInset() {
        return this.getRight() - this.getRightInset();
    }

    @Override
    public float getTopAfterInset() {
        return this.getTop() + this.getTopInset();
    }

    @Override
    public String toString() {
        if ((double)Math.abs(this.leftInset) > 0.1 || (double)Math.abs(this.rightInset) > 0.1 || (double)Math.abs(this.topInset) > 0.1 || (double)Math.abs(this.bottomInset) > 0.1) {
            return super.toString() + "[" + StringTool.getStrValue(this.leftInset) + "," + StringTool.getStrValue(this.rightInset) + "," + StringTool.getStrValue(this.topInset) + "," + StringTool.getStrValue(this.bottomInset) + "]";
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        RectangleFWithInsets newRect = (RectangleFWithInsets)super.clone();
        RectangleFWithInsets rectangleFWithInsets = this;
        synchronized (rectangleFWithInsets) {
            if (newRect != null) {
                newRect.leftInset = this.leftInset;
                newRect.rightInset = this.rightInset;
                newRect.topInset = this.topInset;
                newRect.bottomInset = this.bottomInset;
            }
        }
        return newRect;
    }
}

