/*
 * Decompiled with CFR 0.152.
 */
package cpcns.defs;

import cpcns.defs.IPoint;
import cpcns.defs.IRectangle;
import cpcns.defs.ISize;
import cpcns.defs.PointF;
import cpcns.defs.SizeF;

public class RectangleF
implements IRectangle,
Cloneable {
    private float x;
    private float y;
    private float width;
    private float height;

    public RectangleF(double x, double y, double width, double height) {
        this.x = (float)x;
        this.y = (float)y;
        this.width = (float)width;
        this.height = (float)height;
    }

    public RectangleF(IPoint point, ISize size) {
        this.x = point.getX();
        this.y = point.getY();
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public RectangleF(IRectangle rect) {
        this.x = rect.getX();
        this.y = rect.getY();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
    }

    @Override
    public boolean contains(IPoint pt) {
        return pt.getX() >= this.x && pt.getY() >= this.y && pt.getX() - this.x <= this.width && pt.getY() - this.y <= this.height;
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= (double)this.x && y >= (double)this.y && x - (double)this.x <= (double)this.width && y - (double)this.y <= (double)this.height;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RectangleF)) {
            return false;
        }
        RectangleF r = (RectangleF)object;
        return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
    }

    public int hashCode() {
        return (int)this.x ^ (int)this.y ^ (int)this.width ^ (int)this.height;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "]";
    }

    public IPoint getLocation() {
        return new PointF(this.x, this.y);
    }

    public ISize getSize() {
        return new SizeF(this.width, this.height);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(float w) {
        this.width = w;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(float h) {
        this.height = h;
    }

    @Override
    public float getLeft() {
        return this.getX();
    }

    @Override
    public float getTop() {
        return this.getY();
    }

    @Override
    public float getBottom() {
        return this.getY() + this.getHeight();
    }

    @Override
    public float getRight() {
        return this.getX() + this.getWidth();
    }

    @Override
    public void setLocation(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    @Override
    public void setSize(double width, double height) {
        this.width = (float)width;
        this.height = (float)height;
    }

    @Override
    public IRectangle getBounds() {
        return new RectangleF(this.x, this.y, this.width, this.height);
    }

    @Override
    public void setBounds(IRectangle rect) {
        this.x = rect.getX();
        this.y = rect.getY();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
    }

    @Override
    public void setBounds(double x, double y, double w, double h) {
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    @Override
    public boolean contains(IRectangle rect) {
        if (rect.getLeft() < this.getLeft()) {
            return false;
        }
        if (rect.getRight() > this.getRight()) {
            return false;
        }
        if (rect.getTop() < this.getTop()) {
            return false;
        }
        return !(rect.getBottom() > this.getBottom());
    }

    @Override
    public boolean equals(IRectangle rect) {
        if (rect == null) {
            return false;
        }
        return (double)Math.abs(this.x - rect.getX()) < 0.01 && (double)Math.abs(this.y - rect.getY()) < 0.01 && (double)Math.abs(this.height - rect.getHeight()) < 0.01 && (double)Math.abs(this.width - rect.getWidth()) < 0.01;
    }

    @Override
    public boolean intersects(IRectangle r) {
        float tw = this.width;
        float th = this.height;
        float rw = r.getWidth();
        float rh = r.getHeight();
        if (rw <= 0.0f || rh <= 0.0f || tw <= 0.0f || th <= 0.0f) {
            return false;
        }
        float tx = this.x;
        float ty = this.y;
        float rx = r.getX();
        float ry = r.getY();
        return ((rw += rx) < rx || rw > tx) && ((rh += ry) < ry || rh > ty) && ((tw += tx) < tx || tw > rx) && ((th += ty) < ty || th > ry);
    }

    @Override
    public float getCenterX() {
        return this.x + this.width / 2.0f;
    }

    @Override
    public float getCenterY() {
        return this.y + this.height / 2.0f;
    }

    @Override
    public void add(double x, double y) {
        double x1 = Math.min((double)this.getLeft(), x);
        double x2 = Math.max((double)this.getRight(), x);
        double y1 = Math.min((double)this.getTop(), y);
        double y2 = Math.max((double)this.getBottom(), y);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void add(IPoint pt) {
        this.add(pt.getX(), pt.getY());
    }

    @Override
    public void add(IRectangle rect) {
        double x1 = Math.min(this.getLeft(), rect.getLeft());
        double x2 = Math.max(this.getRight(), rect.getRight());
        double y1 = Math.min(this.getTop(), rect.getTop());
        double y2 = Math.max(this.getBottom(), rect.getBottom());
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        RectangleF newRect = (RectangleF)super.clone();
        RectangleF rectangleF = this;
        synchronized (rectangleF) {
            if (newRect != null) {
                newRect.setX(this.x);
                newRect.setY(this.y);
                newRect.setWidth(this.width);
                newRect.setHeight(this.height);
            }
        }
        return newRect;
    }
}

