/*
 * Decompiled with CFR 0.152.
 */
package cpcns.defs;

import cpcns.defs.IListEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayListWithEvent<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -3315081446070272843L;
    private List<IListEventListener> _listeners = null;

    public ArrayListWithEvent() {
    }

    public ArrayListWithEvent(Collection<? extends E> c) {
        super(c);
    }

    public ArrayListWithEvent(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public E set(int i, E object) {
        E e = super.set(i, object);
        this.fireElementUpdated(object);
        return e;
    }

    @Override
    public boolean add(E object) {
        boolean flag = super.add(object);
        this.fireElementAdded(object);
        return flag;
    }

    @Override
    public void add(int i, E object) {
        super.add(i, object);
        this.fireElementAdded(object);
    }

    @Override
    public boolean remove(Object object) {
        boolean flag = super.remove(object);
        this.fireElementRemoved(object);
        return flag;
    }

    @Override
    public E remove(int i) {
        Object obj = super.remove(i);
        this.fireElementRemoved(obj);
        return obj;
    }

    @Override
    public void clear() {
        super.clear();
        this.fireCleared();
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> collection) {
        boolean falg = super.addAll(i, collection);
        for (E obj : collection) {
            this.fireElementAdded(obj);
        }
        return falg;
    }

    public void addArrayListListener(IListEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList<IListEventListener>();
        }
        this._listeners.add(listener);
    }

    public void removeArrayListListener(IListEventListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    private void fireElementAdded(Object ele) {
        if (this._listeners == null) {
            return;
        }
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).elementAdded(this, ele);
        }
    }

    private void fireElementRemoved(Object ele) {
        if (this._listeners == null) {
            return;
        }
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).elementRemoved(this, ele);
        }
    }

    private void fireElementUpdated(Object ele) {
        if (this._listeners == null) {
            return;
        }
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).elementUpdated(this, ele);
        }
    }

    private void fireCleared() {
        if (this._listeners == null) {
            return;
        }
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).cleared();
        }
    }
}

