/*
 * Decompiled with CFR 0.152.
 */
package cpcns.office;

import cpcns.detect.Detectors;
import cpcns.io.RandomAccessFileInputStream;
import cpcns.office.packer.AbstractPacker;
import cpcns.util.ClassTool;
import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import cpcns.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackerFactory {
    private static Log log = LogFactory.getLog(PackerFactory.class);
    private Map<String, AbstractPacker> packers = new HashMap<String, AbstractPacker>();
    private static PackerFactory instance = new PackerFactory();

    private PackerFactory() {
        this.loadConfig();
    }

    public static PackerFactory getInstance() {
        return instance;
    }

    private void registePacker(String name, AbstractPacker ap) {
        if (name != null && ap != null) {
            this.packers.put(name, ap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        InputStream is = AbstractPacker.class.getResourceAsStream("packer.properties");
        Properties prop = new Properties();
        try {
            prop.load(is);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        for (String key : prop.stringPropertyNames()) {
            String val = prop.getProperty(key);
            if (key == null || val == null) continue;
            Class c = ClassTool.getClass((String)val);
            if (c == null) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Failed load class :" + val));
                continue;
            }
            try {
                Object o = c.newInstance();
                AbstractPacker ap = (AbstractPacker)AbstractPacker.class.cast(o);
                this.registePacker(key, ap);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public AbstractPacker getPacker(String name) {
        return this.packers.get(name);
    }

    public InputStream packCommon2PDF(File ... files) throws IOException {
        return this.packCommon(Arrays.asList(files), true, "pdf", "wenjian.tongyong");
    }

    public InputStream packCommon(List<File> files, boolean flag, String targetFormat) throws IOException {
        return this.packCommon(files, flag, targetFormat, "wenjian.tongyong");
    }

    public InputStream packCommon(List<File> files, boolean flag, String targetFormat, String type) throws IOException {
        if (files == null || files.isEmpty()) {
            return null;
        }
        targetFormat = targetFormat != null && "pdf".equalsIgnoreCase(targetFormat) ? "pdf" : "ofd";
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<FileRoot Type=\"" + type + "\" Target=\"").append(targetFormat).append("\"").append(" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:SchemaLocation=\"packagefile.xsd\">\n");
        xml.append("\t<DocBody>\n");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            String name = file.getName();
            int index = name.lastIndexOf(".");
            String suffix = "dat";
            if (index == -1) {
                try {
                    suffix = Detectors.suffix((File)file);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                suffix = name.substring(index + 1);
            }
            String url = "";
            if (flag) {
                String n = i + "." + suffix;
                url = "/" + n;
                map.put(n, file);
            } else {
                url = file.toURI().toURL().toExternalForm();
            }
            xml.append("\t\t<Component ID=\"").append(i).append("\">\n");
            xml.append("\t\t\t<File Format=\"").append(suffix).append("\">\n");
            xml.append("\t\t\t\t<FileLoc>").append(url).append("</FileLoc>\n");
            xml.append("\t\t\t</File>\n");
            xml.append("\t\t</Component>\n");
        }
        xml.append("\t</DocBody>\n");
        xml.append("</FileRoot>");
        if (flag) {
            return this.saveZIP(xml, map);
        }
        return this.saveZIP(xml);
    }

    public InputStream packHTML(List<URL> urls) throws IOException {
        if (urls == null || urls.isEmpty()) {
            return null;
        }
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<FileRoot Type=\"wangye.guotu\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:SchemaLocation=\"packagefile.xsd\">\n");
        xml.append("\t<DocBody>\n");
        int i = 1;
        for (URL url : urls) {
            xml.append("\t\t<Component ID=\"").append(i++).append("\">\n");
            xml.append("\t\t\t<File Format=\"html\">\n");
            xml.append("\t\t\t\t<FileLoc>").append(url.toString()).append("</FileLoc>\n");
            xml.append("\t\t\t</File>\n");
            xml.append("\t\t</Component>\n");
        }
        xml.append("\t</DocBody>\n");
        xml.append("</FileRoot>");
        return this.saveZIP(xml);
    }

    public InputStream packMerge(List<File> files, boolean flag) throws IOException {
        if (files == null || files.isEmpty()) {
            return null;
        }
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<FileRoot Type=\"qikan.guotu\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:SchemaLocation=\"packagefile.xsd\">\n");
        xml.append("\t<DocBody>\n");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            String name = file.getName();
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            if (!suffix.equalsIgnoreCase("ofd")) continue;
            String url = "";
            if (flag) {
                String n = i + ".ofd";
                url = "/" + n;
                map.put(n, file);
            } else {
                url = file.toURI().toURL().toExternalForm();
            }
            xml.append("\t\t<Component ID=\"").append(i).append("\">\n");
            xml.append("\t\t\t<File Format=\"ofd\">\n");
            xml.append("\t\t\t\t<FileLoc>").append(url).append("</FileLoc>\n");
            xml.append("\t\t\t</File>\n");
            xml.append("\t\t</Component>\n");
        }
        xml.append("\t</DocBody>\n");
        xml.append("</FileRoot>");
        if (flag) {
            return this.saveZIP(xml, map);
        }
        return this.saveZIP(xml);
    }

    public InputStream packTemplate(Map<File, InputStream> files, String targetFormat) throws IOException {
        if (files == null || files.isEmpty()) {
            return null;
        }
        targetFormat = targetFormat != null && "pdf".equalsIgnoreCase(targetFormat) ? "pdf" : "ofd";
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<FileRoot Type=\"wenjian.tongyong\" Target=\"").append(targetFormat).append("\"").append(" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:SchemaLocation=\"packagefile.xsd\">\n");
        xml.append("\t<DocBody>\n");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int i = 0;
        for (Map.Entry<File, InputStream> en : files.entrySet()) {
            File tpl = en.getKey();
            String tplName = tpl.getName();
            String tplSuffix = tplName.substring(tplName.lastIndexOf(".") + 1);
            String n = i++ + "." + tplSuffix;
            String tplURL = "/" + n;
            map.put(n, tpl);
            InputStream data = en.getValue();
            n = i++ + ".xml";
            String dataURL = "/" + n;
            map.put(n, data);
            xml.append("\t\t<Component ID=\"").append(i).append("\">\n");
            xml.append("\t\t\t<Data TempType=\"").append(tplSuffix).append("\">\n");
            xml.append("\t\t\t\t<Template>").append(tplURL).append("</Template>\n");
            xml.append("\t\t\t\t<FileLoc>").append(dataURL).append("</FileLoc>\n");
            xml.append("\t\t\t</Data>\n");
            xml.append("\t\t</Component>\n");
        }
        xml.append("\t</DocBody>\n");
        xml.append("</FileRoot>");
        return this.saveZIP(xml, map);
    }

    private InputStream saveZIP(CharSequence xml) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        ZipEntry ze = new ZipEntry("Main.xml");
        zos.putNextEntry(ze);
        zos.write(xml.toString().getBytes("UTF-8"));
        zos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream saveZIP(CharSequence xml, Map<String, Object> map) throws IOException {
        File temp = File.createTempFile(this.getClass().getSimpleName() + "_", ".zip");
        ZipOutputStream zos = new ZipOutputStream(FileUtils.openOutputStream((File)temp));
        ZipEntry ze = new ZipEntry("Main.xml");
        zos.putNextEntry(ze);
        zos.write(xml.toString().getBytes("UTF-8"));
        zos.closeEntry();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, Object> en : map.entrySet()) {
                String name = en.getKey();
                Object v = en.getValue();
                InputStream is = null;
                if (v instanceof File) {
                    is = FileUtils.openInputStream((File)((File)v));
                } else if (v instanceof byte[]) {
                    is = new ByteArrayInputStream((byte[])v);
                } else if (v instanceof InputStream) {
                    is = (InputStream)v;
                }
                try {
                    zos.putNextEntry(new ZipEntry(name));
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    zos.closeEntry();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
        zos.close();
        return new DelWhenClose(temp);
    }

    public static void main(String[] args) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            list.add(new File("D:/1.ofd"));
            ArrayList<URL> us = new ArrayList<URL>();
            us.add(new URL("http://www.baidu.com"));
            InputStream is = PackerFactory.getInstance().packMerge(list, true);
            StreamUtils.store((InputStream)is, (File)new File("D:/out.zip"));
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class DelWhenClose
    extends RandomAccessFileInputStream {
        public DelWhenClose(File file) throws IOException {
            super(file, true);
        }

        public void close() throws IOException {
            this.release();
        }
    }
}

