/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.ziputils;

import cpcns.convert.ziputils.ByteTool;
import cpcns.convert.ziputils.EnvelopeOptions;
import cpcns.convert.ziputils.XmlTool;
import cpcns.util.StringTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static byte[] metadata(Map<String, String> metas) throws Exception {
        if (metas == null || metas.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\r\n");
        sb.append("<MetaRoot xs:SchemaLocation=\"metadata.xsd\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\">");
        sb.append("\r\n");
        for (Map.Entry<String, String> entry : metas.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append("    ");
            sb.append("<" + key + ">" + XmlTool.HTMLDecode(value) + "</" + key + ">");
            sb.append("\r\n");
        }
        sb.append("</MetaRoot>");
        String content = sb.toString();
        return content.getBytes("utf-8");
    }

    private static byte[] metadata(Map<String, String> metas, Map<String, String> custems) throws Exception {
        String value;
        String key;
        if (metas == null || metas.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\r\n");
        sb.append("<MetaRoot xs:SchemaLocation=\"metadata.xsd\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\">");
        sb.append("\r\n");
        for (Map.Entry<String, String> entry : metas.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            sb.append("    ");
            sb.append("<" + key + ">" + XmlTool.HTMLDecode(value) + "</" + key + ">");
            sb.append("\r\n");
        }
        if (custems.size() > 0) {
            sb.append("    ");
            sb.append("<CustomDatas>");
            sb.append("\r\n");
            for (Map.Entry<String, String> entry : custems.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                sb.append("    ");
                sb.append("    ");
                sb.append("<CustomData Name=\"" + key + "\">");
                sb.append(XmlTool.HTMLDecode(value));
                sb.append("</CustomData>");
                sb.append("\r\n");
            }
            sb.append("    ");
            sb.append("</CustomDatas>");
            sb.append("\r\n");
        }
        sb.append("</MetaRoot>");
        String content = sb.toString();
        return content.getBytes("utf-8");
    }

    public static File zipFile(Map<String, String> metas, List<String> fileList) throws Exception {
        return ZipUtil.zipFile(metas, fileList, null);
    }

    public static File zipFile(Map<String, String> metas, List<String> fileList, EnvelopeOptions eos) throws Exception {
        return ZipUtil.zipFile(ZipUtil.metadata(metas), fileList, "wenjian.tongyong", "ofd", eos);
    }

    public static File zipFile(Map<String, String> metas, Map<String, String> customs, List<String> fileList, EnvelopeOptions eos, String target) throws Exception {
        return ZipUtil.zipFile(ZipUtil.metadata(metas, customs), fileList, "wenjian.tongyong", target, eos);
    }

    public static File zipFile(byte[] metadata, List<String> fileList, String type, String target, EnvelopeOptions eos) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\r\n");
        sb.append("<FileRoot Type=\"" + type + "\">");
        sb.append("\r\n");
        String mdName = null;
        if (metadata != null) {
            mdName = ByteTool.md5(metadata) + ".xml";
            sb.append("    ");
            sb.append("<Metadata>" + mdName + "</Metadata>");
            sb.append("\r\n");
        }
        HashMap<String, String> names = new HashMap<String, String>();
        int i = 1;
        String name = null;
        if (fileList != null && !fileList.isEmpty()) {
            sb.append("    ");
            sb.append("<DocBody>");
            sb.append("\r\n");
            for (String s : fileList) {
                if (StringTool.isBlank((String)s)) continue;
                String n = String.valueOf(i++);
                String format = s.substring(s.lastIndexOf(".") + 1, s.length());
                name = "/Files/" + n + "." + format;
                sb.append("        ");
                sb.append("<Component ID=\"" + n + "\">");
                sb.append("\r\n");
                sb.append("            ");
                sb.append("<File Format=\"" + format + "\" Title=\"" + new File(s).getName() + "\">");
                sb.append("\r\n");
                sb.append("                ");
                names.put(s, name);
                sb.append("<FileLoc>" + name + "</FileLoc>");
                sb.append("\r\n");
                sb.append("            ");
                sb.append("</File>");
                sb.append("\r\n");
                sb.append("        ");
                sb.append("</Component>");
                sb.append("\r\n");
            }
            sb.append("    ");
            sb.append("</DocBody>");
            sb.append("\r\n");
        }
        sb.append("</FileRoot>");
        String content = sb.toString();
        File zip = File.createTempFile("file_", ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
        ZipUtil.makeZip(zos, fileList, names);
        ZipEntry me = new ZipEntry("Main.xml");
        zos.putNextEntry(me);
        zos.write(content.getBytes("utf-8"));
        zos.closeEntry();
        if (metadata != null) {
            ZipEntry de = new ZipEntry(mdName);
            zos.putNextEntry(de);
            zos.write(metadata);
            zos.closeEntry();
        }
        zos.close();
        return zip;
    }

    private static void makeZip(ZipOutputStream zos, List<String> fileList, Map<String, String> names) throws IOException {
        for (String file : fileList) {
            File f = new File(file);
            if (!f.isFile()) continue;
            String val = names.get(file);
            String file_name = val == null ? f.getName() : val;
            ZipEntry ze = new ZipEntry(file_name);
            zos.putNextEntry(ze);
            ZipUtil.copyFileToZip(zos, f);
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToZip(ZipOutputStream zos, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] b = new byte[10240];
            int l = -1;
            while ((l = fis.read(b)) != -1) {
                zos.write(b, 0, l);
            }
        }
        finally {
            fis.close();
        }
    }

    public static String HTMLDecode(String text) {
        if (text == null) {
            return null;
        }
        if (text.indexOf("&nbsp;") > 0) {
            text = text.replace("&nbsp;", " ");
        }
        if (text.indexOf("&quot;") > 0) {
            text = text.replace("&quot;", "&");
        }
        if (text.indexOf("&quot;") > 0) {
            text = text.replace("&quot;", "\"");
        }
        if (text.indexOf("&lt;") > 0) {
            text = text.replace("&lt;", "<");
        }
        if (text.indexOf("&gt;") > 0) {
            text = text.replace("&gt;", ">");
        }
        if (text.indexOf("&apos;") > 0) {
            text = text.replace("&apos;", "'");
        }
        return text;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("D:/5000\u9875.docx");
        try {
            System.out.println(ZipUtil.zipFile(null, list, "custom.pdf", "pdf", null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

