/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.pool;

import cpcns.convert.pool.AbstractPool;
import cpcns.convert.pool.IPool;
import cpcns.convert.pool.IPoolItemFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class DefaultPool<T>
extends AbstractPool<T>
implements IPool<T> {
    private int size;
    private Queue<T> queue;
    private List<T> using;
    private IPoolItemFactory<T> factory;
    private IPool.Validator<T> validator;
    private Semaphore locker;

    public DefaultPool(int size, IPool.Validator<T> validator, IPoolItemFactory<T> factory) {
        this.size = size;
        this.validator = validator;
        this.factory = factory;
        this.queue = new LinkedBlockingQueue<T>();
        this.using = new ArrayList<T>();
        this.locker = new Semaphore(this.size);
    }

    @Override
    public T get() {
        return this.get(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public T get(long time, TimeUnit unit) {
        try {
            if (this.locker.tryAcquire(time, unit)) {
                T t = this.queue.poll();
                if (t == null) {
                    t = this.factory.create();
                }
                this.using.add(t);
                return t;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void dispose() {
        Object t = null;
        while (true) {
            T t2 = this.queue.poll();
            t = t2;
            if (t2 == null) break;
            this.validator.destroy(t);
        }
        for (T u : this.using) {
            this.validator.destroy(u);
        }
        this.locker.release(this.size);
    }

    @Override
    protected void handleInvalid(T t) {
        if (t == null) {
            return;
        }
        this.queue.remove(t);
        this.using.remove(t);
        this.locker.release();
        this.validator.destroy(t);
    }

    @Override
    protected void returnToPool(T t) {
        if (t == null) {
            return;
        }
        this.using.remove(t);
        if (this.queue.add(t)) {
            this.locker.release();
        }
    }

    @Override
    protected boolean isValid(T t) {
        if (t == null) {
            return false;
        }
        return this.validator.isValid(t);
    }

    public static void main(String[] args) {
        final DefaultPool<String> pool = new DefaultPool<String>(3, new IPool.Validator<String>(){

            @Override
            public boolean isValid(String t) {
                return true;
            }

            @Override
            public void destroy(String t) {
            }
        }, new IPoolItemFactory<String>(){

            @Override
            public String create() {
                return "T-" + new Random().nextInt(1000);
            }
        });
        for (int i = 0; i < 5; ++i) {
            new Thread("THREAD-" + i){

                @Override
                public void run() {
                    while (true) {
                        String s = (String)pool.get(10L, TimeUnit.SECONDS);
                        System.out.println(this.getName() + " GET " + s);
                        try {
                            Thread.sleep(new Random().nextInt(10) * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.out.println(this.getName() + " RELEASE " + s);
                        pool.release(s);
                    }
                }
            }.start();
        }
    }
}

