/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.model;

import cpcns.convert.model.TaskStatus;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PageInfo {
    private int offset;
    private int count;
    private List<Condition> conditions;
    private List<Order> orders;

    public PageInfo(int offset, int count) {
        this.offset = offset;
        this.count = count;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    public PageInfo where(Clause where) {
        if (where == null) {
            return this;
        }
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(new Condition(Hyphen.WHERE, where));
        return this;
    }

    public PageInfo and(Clause and) {
        if (and == null) {
            return this;
        }
        if (this.conditions == null) {
            throw new IllegalStateException("WHERE first!");
        }
        this.conditions.add(new Condition(Hyphen.AND, and));
        return this;
    }

    public PageInfo or(Clause or) {
        if (or == null) {
            return this;
        }
        if (this.conditions == null) {
            throw new IllegalStateException("WHERE first!");
        }
        this.conditions.add(new Condition(Hyphen.OR, or));
        return this;
    }

    public PageInfo order(Order order) {
        if (order == null) {
            return this;
        }
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(order);
        return this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public String toString() {
        return "PageInfo [\u504f\u79fb=" + this.offset + ", \u6570\u91cf=" + this.count + ", \u6761\u4ef6=" + this.conditions + ", \u6392\u5e8f=" + this.orders + "]";
    }

    public String toSQL(Map<String, String> fields, LinkedHashMap<Object, Integer> params, boolean appendOrder) {
        List<Condition> cons = this.getConditions();
        if (cons == null) {
            return "";
        }
        params.clear();
        StringBuilder sql = new StringBuilder();
        sql.append(this.toSQL(cons, fields, params));
        if (appendOrder && this.getOrders() != null) {
            int i = 0;
            for (Order o : this.getOrders()) {
                String name = fields.get(o.getName().toLowerCase());
                if (name == null) continue;
                if (i == 0) {
                    sql.append(" order by ");
                } else {
                    sql.append(",");
                }
                sql.append(name).append(" ").append(o.isAsc() ? "asc" : "desc");
                ++i;
            }
        }
        return sql.toString();
    }

    private String toSQL(List<Condition> cons, Map<String, String> fields, LinkedHashMap<Object, Integer> params) {
        StringBuilder sql = new StringBuilder();
        for (Condition c : cons) {
            Clause d = c.getClause();
            Hyphen hyphen = c.getHyphen();
            sql.append(" ").append(hyphen);
            if (d instanceof Article) {
                Article a = (Article)d;
                String name = fields.get(a.getName().toLowerCase());
                if (name == null) continue;
                Operation op = a.getOperation();
                Object v = a.getValue();
                sql.append(" ").append(name).append(" ").append((Object)op).append(" ");
                if (op == Operation.is && (v == "NULL" || v == "NOT NULL")) {
                    sql.append(v.toString());
                    continue;
                }
                sql.append("?");
                params.put(a.getValue(), a.getSqlType());
                continue;
            }
            if (!(d instanceof Bracket)) continue;
            Bracket b = (Bracket)d;
            String wrap = this.toSQL(b.getConditions(), fields, params);
            sql.append(" (").append(wrap.trim()).append(")");
        }
        return sql.toString();
    }

    public static void main(String[] args) {
        PageInfo info = new PageInfo(0, 100);
        info.where(new Article("status", Operation.eq, TaskStatus.working.intValue())).and(new Bracket(new Article("beginTime", Operation.lt, new Timestamp(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L)))).or(new Article("beginTime", Operation.is, "NULL")).and(new Bracket(new Article("beginTime", Operation.lt, new Timestamp(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L)))).or(new Article("beginTime", Operation.is, "NULL")))).or(new Article("beginTime", Operation.is, "NULL")).order(new Order("beginTime", true)).order(new Order("id", false));
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", "id");
        fields.put("docid", "doc_id");
        fields.put("sourcepath", "src_path");
        fields.put("ticket", "ticket");
        fields.put("status", "status");
        fields.put("begintime", "start_time");
        fields.put("finishtime", "finish_time");
        LinkedHashMap<Object, Integer> params = new LinkedHashMap<Object, Integer>();
        String sql = info.toSQL(fields, params, true);
        System.out.println(sql);
        System.out.println(params);
    }

    public static class Order {
        private String name;
        private boolean asc;

        public Order(String name, boolean asc) {
            this.name = name;
            this.asc = asc;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public String toString() {
            return "[name=" + this.name + ", asc=" + this.asc + "]";
        }
    }

    public static class Bracket
    implements Clause {
        private List<Condition> list = new ArrayList<Condition>();

        public Bracket(Clause first) {
            this.list.add(new Condition(Hyphen.EMPTY, first));
        }

        public Bracket and(Clause and) {
            if (and == null) {
                return this;
            }
            this.list.add(new Condition(Hyphen.AND, and));
            return this;
        }

        public Bracket or(Clause or) {
            if (or == null) {
                return this;
            }
            this.list.add(new Condition(Hyphen.OR, or));
            return this;
        }

        public List<Condition> getConditions() {
            return this.list;
        }

        public String toString() {
            return "[" + this.list + "]";
        }
    }

    public static enum Operation {
        eq{

            public String toString() {
                return "=";
            }
        }
        ,
        neq{

            public String toString() {
                return "<>";
            }
        }
        ,
        gt{

            public String toString() {
                return ">";
            }
        }
        ,
        gte{

            public String toString() {
                return ">=";
            }
        }
        ,
        lt{

            public String toString() {
                return "<";
            }
        }
        ,
        lte{

            public String toString() {
                return "<=";
            }
        }
        ,
        like{

            public String toString() {
                return "like";
            }
        }
        ,
        is{

            public String toString() {
                return "is";
            }
        };

    }

    public static class Article
    implements Clause {
        public static final String NULL = "NULL";
        public static final String NOT_NULL = "NOT NULL";
        private String name;
        private Object value;
        private Operation operation;
        private int sqlType;

        public Article(String name, Operation operation, String value) {
            this(name, operation, value, 12);
        }

        public Article(String name, Operation operation, int value) {
            this(name, operation, value, 4);
        }

        public Article(String name, Operation operation, Timestamp value) {
            this(name, operation, value, 93);
        }

        public Article(String name, Operation operation, Object value, int sqlType) {
            this.name = name;
            this.operation = operation;
            this.value = value;
            this.sqlType = sqlType;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public String toString() {
            return this.name + " " + (Object)((Object)this.operation) + " " + this.value + "(sqlType=" + this.sqlType + ")";
        }
    }

    public static interface Clause {
    }

    public static class Hyphen {
        public static final Hyphen WHERE = new Hyphen("where");
        public static final Hyphen AND = new Hyphen("and");
        public static final Hyphen OR = new Hyphen("or");
        public static final Hyphen EMPTY = new Hyphen(" ");
        private String hyphen;

        private Hyphen(String hyphen) {
            this.hyphen = hyphen;
        }

        public String toString() {
            return this.hyphen;
        }
    }

    public static class Condition {
        private Hyphen hyphen;
        private Clause clause;

        public Condition(Hyphen hyphen, Clause Clause2) {
            this.hyphen = hyphen;
            this.clause = Clause2;
        }

        public Hyphen getHyphen() {
            return this.hyphen;
        }

        public Clause getClause() {
            return this.clause;
        }

        public String toString() {
            return "[" + this.hyphen + " " + this.clause + "]";
        }
    }
}

