/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.impl;

import cpcns.util.JarUtils;
import cpcns.util.OS;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginUtil {
    private static Log log = LogFactory.getLog(PluginUtil.class);
    private static Arch arch;

    public static String filePath(Class<?> c, String name) {
        File file;
        File dir;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try find " + name));
        }
        if ((dir = JarUtils.findJarDir(c)).getName().endsWith("bin")) {
            dir = dir.getParentFile();
        }
        if (!(file = new File(dir, name)).exists()) {
            file = new File(dir, "lib/" + name);
        }
        String ret = null;
        if (file.exists()) {
            ret = file.getAbsolutePath();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Find " + name + ", path is " + ret));
        }
        return ret;
    }

    public static Space[] timeout(String time) {
        if (time == null) {
            return null;
        }
        String[] array = time.split(";");
        if (array == null || array.length == 0) {
            return null;
        }
        int size = array.length;
        TreeMap<Long, Object> map = new TreeMap<Long, Object>();
        for (int i = 0; i < size - 1; ++i) {
            String vt = array[i];
            String[] vs = vt.split("=");
            if (vs == null || vs.length != 2) continue;
            Long k = PluginUtil.size(vs[0]);
            Integer v = Integer.valueOf(vs[1].trim());
            map.put(k, v);
        }
        Space[] ss = new Space[map.size() + 1];
        long last = 0L;
        int index = 0;
        for (Map.Entry en : map.entrySet()) {
            Long key = (Long)en.getKey();
            ss[index++] = new Space(last, key, (Integer)en.getValue());
            last = key;
        }
        String max = array[size - 1].trim();
        Integer v = Integer.valueOf(max);
        ss[index++] = new Space(last, Integer.MAX_VALUE, v);
        return ss;
    }

    private static long size(String size) {
        if (size == null) {
            return 0L;
        }
        char c = (size = size.trim()).charAt(size.length() - 1);
        if (Character.isDigit(c)) {
            return Long.valueOf(size);
        }
        Long v = Long.valueOf(size.substring(0, size.length() - 1));
        if (c == 'K' || c == 'k') {
            return v * 1024L;
        }
        if (c == 'M' || c == 'm') {
            return v * 1024L * 1024L;
        }
        if (c == 'G' || c == 'g') {
            return v * 1024L * 1024L * 1024L;
        }
        return 0L;
    }

    public static Arch arch() {
        return arch;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        String oa = System.getProperty("os.arch").toLowerCase();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OS Name is " + os));
            log.debug((Object)("OS Arch is " + oa));
        }
        if (OS.isWindows()) {
            arch = Arch.win;
        } else if (OS.isMips()) {
            arch = OS.isX64() ? Arch.mips64 : Arch.mips;
        } else if (OS.isArm()) {
            arch = OS.isX64() ? Arch.arm64 : Arch.arm;
        } else if (OS.isLinux()) {
            arch = OS.isX64() ? Arch.x64_linux : Arch.x86_linux;
        } else {
            log.warn((Object)"What's os?");
        }
    }

    public static enum Arch {
        win{

            @Override
            public String process(String name) {
                return name == null ? null : name + ".exe";
            }

            @Override
            public String dirName() {
                return "windows";
            }
        }
        ,
        x86_linux{

            @Override
            public String dirName() {
                return "x86-linux";
            }
        }
        ,
        x64_linux{

            @Override
            public String dirName() {
                return "x64-linux";
            }
        }
        ,
        mips,
        mips64,
        arm,
        arm64;


        public String process(String name) {
            return name;
        }

        public String dirName() {
            return this.name();
        }
    }

    public static class Space {
        public final long min;
        public final long max;
        public final int time;

        public Space(long min, long max, int time) {
            this.min = min;
            this.max = max;
            this.time = time;
        }

        public String toString() {
            return "(" + this.min + ", " + this.max + "]=" + this.time + "m ";
        }
    }
}

