/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.impl;

import cpcns.convert.EmptyFileException;
import cpcns.convert.impl.BaseConvertor;
import cpcns.convert.impl.PluginUtil;
import cpcns.util.FileUtils;
import cpcns.util.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CommandConvertor
extends BaseConvertor {
    private static Log log = LogFactory.getLog(CommandConvertor.class);
    protected Process process;
    private InputStream pin;
    protected boolean timeout;
    protected String application;
    private File srcTemp = null;
    private File dstTemp = null;
    private String srcPath;

    public void setApplication(String path) {
        this.application = path;
    }

    @Override
    public void init() {
    }

    @Override
    protected void release() {
        super.release();
        this.timeout = false;
        if (this.srcTemp != null && this.srcTemp.exists() && !FileUtils.deleteQuietly((File)this.srcTemp)) {
            log.warn((Object)String.format("Delete file %s failed", this.srcTemp.getAbsolutePath()));
        }
        if (this.dstTemp != null && this.dstTemp.exists() && !FileUtils.deleteQuietly((File)this.dstTemp)) {
            log.warn((Object)String.format("Delete file %s failed", this.dstTemp.getAbsolutePath()));
        }
    }

    private void exit() {
        if (this.process != null) {
            log.debug((Object)"Destroy process...");
            this.process.destroy();
            this.process = null;
        }
        if (this.pin != null) {
            try {
                this.pin.close();
                this.pin = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void destroy() {
        this.exit();
    }

    @Override
    protected void whenTimeout(TimeoutException e) {
        this.timeout = true;
        super.whenTimeout(e);
    }

    @Override
    protected long sourceSize() throws IOException {
        this.source();
        File file = new File(this.srcPath);
        return file.length();
    }

    private void source() throws IOException {
        if (this.srcPath != null) {
            return;
        }
        if (this.src instanceof File) {
            this.srcPath = ((File)this.src).getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Source is File, path = " + this.srcPath));
            }
        } else if (this.src instanceof InputStream) {
            String name;
            InputStream is = (InputStream)this.src;
            String string = name = this.args == null ? null : (String)this.args.get("_srcName");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Source name is " + name));
            }
            String suffix = this.findSuffix(name, ".dat");
            this.srcTemp = File.createTempFile(this.getClass().getSimpleName() + "_", suffix);
            StreamUtils.store((InputStream)is, (File)this.srcTemp);
            this.srcPath = this.srcTemp.getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Source is InputStream, path = " + this.srcPath));
            }
        } else {
            this.srcPath = String.valueOf(this.src);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Source is String, path = " + this.srcPath));
            }
        }
    }

    @Override
    protected final boolean doConvert() throws Exception {
        boolean ret;
        String dstPath;
        this.source();
        boolean isOutput = false;
        if (this.dest instanceof File) {
            dstPath = ((File)this.dest).getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Target is File, path = " + dstPath));
            }
        } else if (this.dest instanceof OutputStream) {
            String name;
            String string = name = this.args == null ? null : (String)this.args.get("_dstName");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Target name is " + name));
            }
            String suffix = this.findSuffix(name, ".ofd");
            this.dstTemp = File.createTempFile(this.getClass().getSimpleName() + "_", suffix);
            dstPath = this.dstTemp.getAbsolutePath();
            isOutput = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Target is OutputStream, path = " + dstPath));
            }
        } else {
            dstPath = String.valueOf(this.dest);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Target is String, path = " + dstPath));
            }
        }
        if (ret = this.doConvert(this.srcPath, dstPath)) {
            File file = new File(dstPath);
            if (file.length() == 0L) {
                throw new EmptyFileException("Target is empty!");
            }
            if (isOutput) {
                StreamUtils.copy((File)this.dstTemp, (OutputStream)((OutputStream)this.dest));
            }
        }
        return ret;
    }

    protected abstract boolean doConvert(String var1, String var2) throws Exception;

    private String findSuffix(String name, String def) {
        int i;
        if (name != null && (i = name.lastIndexOf(".")) != -1) {
            return name.substring(i);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(String app, String ... cmd) throws Exception {
        long l = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Execute command...");
        }
        ArrayList<String> c = new ArrayList<String>();
        c.add(app);
        if (cmd != null && cmd.length > 0) {
            Collections.addAll(c, cmd);
        }
        ProcessBuilder pb = new ProcessBuilder(c).redirectErrorStream(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command : " + pb.command()));
        }
        if (this.process != null) {
            this.exit();
        }
        this.process = pb.start();
        this.pin = this.process.getInputStream();
        BufferedReader out = new BufferedReader(new InputStreamReader(this.pin, PluginUtil.arch() == PluginUtil.Arch.win ? "GBK" : "UTF-8"));
        try {
            String line;
            while (this.process != null && !this.timeout && (line = out.readLine()) != null && this.processLine(line.trim())) {
            }
            this.process.waitFor();
        }
        finally {
            out.close();
        }
        int ret = this.process.exitValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execute command end, cost " + (System.currentTimeMillis() - l) + " ms"));
        }
        return ret;
    }

    protected boolean processLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("> " + line));
        }
        return true;
    }
}

