/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert;

import cpcns.convert.IFileMetaHandler;
import cpcns.defs.ProviderInfo;
import cpcns.util.ClassTool;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileMetaHandlers {
    private static Log log = LogFactory.getLog(FileMetaHandlers.class);
    private static Map<String, IFileMetaHandler> handlers = new HashMap<String, IFileMetaHandler>();

    private static void put(IFileMetaHandler fm) {
        if (fm == null) {
            return;
        }
        ProviderInfo info = fm.getProviderInfo();
        String n = info.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register IFileMetaHandler, name = " + n + ", class = " + fm.getClass().getName()));
        }
        handlers.put(n, fm);
    }

    public static IFileMetaHandler findHandler(String name) {
        Object o;
        if (name == null) {
            return null;
        }
        IFileMetaHandler fmh = handlers.get(name);
        if (fmh != null) {
            return fmh;
        }
        for (IFileMetaHandler m : handlers.values()) {
            String n = m.getClass().getName();
            if (!name.equals(n)) continue;
            return m;
        }
        Class c = ClassTool.getClass((String)name);
        if (c != null && (o = ClassTool.newInstance((Class)c, (Object[])new Object[0])) instanceof IFileMetaHandler) {
            IFileMetaHandler fm = (IFileMetaHandler)o;
            FileMetaHandlers.put(fm);
            return fm;
        }
        return null;
    }

    public static String toString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String sub(String s, int length) {
        if (s == null) {
            return null;
        }
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length);
    }

    public static void main(String[] args) {
        System.out.println(FileMetaHandlers.sub(FileMetaHandlers.toString(new NullPointerException("\u7a7aNULLLLLLLLLLLLL!")), 60));
    }

    static {
        ServiceLoader<IFileMetaHandler> sl = ServiceLoader.load(IFileMetaHandler.class);
        Iterator<IFileMetaHandler> it = sl.iterator();
        while (it.hasNext()) {
            FileMetaHandlers.put(it.next());
        }
    }
}

