/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.icbc.ofd.impl;

import com.google.gson.Gson;
import com.icbc.ofd.IOfdFileUtils;
import com.suwell.icbc.ofd.impl.HtmlUtils;
import com.suwell.local.convert.DataType;
import com.suwell.local.convert.Operate;
import com.suwell.local.convert.PacketMain;
import com.suwell.local.convert.Utils;
import com.suwell.sdk.common.FormHelper;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.ws.commons.util.Base64;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuwellOfdFileUtils
implements IOfdFileUtils {
    private static Logger log = LoggerFactory.getLogger(SuwellOfdFileUtils.class);
    private static final String FINFO_TPL = "!CDATA<Item Font=\"\u5fae\u8f6f\u96c5\u9ed1\" FontSize=\"9\" Weight=\"700\">{0}</Item><Item>{1}</Item>";
    private static final int RQ_OK = 0;
    private static final int RQ_SOC_TYPE_ERROR = 1;
    private static final int RQ_TAR_TYPE_ERROR = 2;
    private static final int RQ_FORM_ERROR = 3;
    private static final int RQ_CONVERT_ERROR = 4;
    private static final int RQ_NOT_FIND = 5;
    private static final int RQ_OTHER_ERROR = 6;
    private static final int RQ_DATA_ERROR = 7;
    private FormHelper formHelper;
    private Gson gson = new Gson();

    public SuwellOfdFileUtils(File root) {
        this.formHelper = FormHelper.create((File)root);
    }

    @Override
    public String create(String template, Map<String, Object> varMap, String fileType, String fileName) {
        if (varMap == null || varMap.isEmpty()) {
            return String.valueOf(7);
        }
        if (fileType == null) {
            fileType = "ofd";
        }
        int rq = 0;
        fileType = fileType.trim().toLowerCase();
        try {
            this.revise(varMap);
            if ("ofd".equals(fileType)) {
                this.formHelper.convertForm(this.gson.toJson(varMap), template, null, DataType.JSON, new File(fileName));
            } else if ("pdf".equals(fileType)) {
                this.formHelper.convertForm(template, null, DataType.JSON, new File(fileName), PacketMain.Target.PDF, new String[]{this.gson.toJson(varMap)});
            } else {
                log.warn("target type {} inoperative !", (Object)fileType);
                rq = 2;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rq = e instanceof FileNotFoundException ? 5 : 6;
        }
        return String.valueOf(rq);
    }

    @Override
    public String batchCreate(String template, List<Map<String, Object>> varList, String fileType) {
        if (varList == null || varList.isEmpty()) {
            return String.valueOf(7);
        }
        String rq = String.valueOf(0);
        for (Map<String, Object> map : varList) {
            String code = this.create(template, map, fileType, String.valueOf(map.get("FILE_NAME")));
            if (code.equals(rq)) continue;
            return code;
        }
        return rq;
    }

    @Override
    public String batchCollectCreate(String template, List<Map<String, Object>> varList, String fileType, String fileName) {
        String[] datas = new String[varList.size()];
        int i = 0;
        for (Map<String, Object> map : varList) {
            this.revise(map);
            datas[i++] = this.gson.toJson(map);
        }
        int rq = 0;
        try {
            if ("ofd".equals(fileType)) {
                this.formHelper.convertForm(template, null, DataType.JSON, new File(fileName), PacketMain.Target.OFD, datas);
            } else if ("pdf".equals(fileType)) {
                this.formHelper.convertForm(template, null, DataType.JSON, new File(fileName), PacketMain.Target.PDF, datas);
            } else {
                log.warn("target type {} inoperative !", (Object)fileType);
                rq = 2;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rq = e instanceof FileNotFoundException ? 5 : 6;
        }
        return String.valueOf(rq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transfer(String originFilePath, String targetFilePath) {
        String souFormat = FilenameUtils.getExtension((String)originFilePath).toLowerCase().trim();
        String tarFormat = FilenameUtils.getExtension((String)targetFilePath).toLowerCase().trim();
        if (tarFormat == null || tarFormat.length() == 0) {
            tarFormat = FilenameUtils.getBaseName((String)targetFilePath).toLowerCase();
        }
        if (souFormat.equals(tarFormat)) {
            log.warn("{} to {} ?", (Object)souFormat, (Object)tarFormat);
            return String.valueOf(4);
        }
        boolean clean = false;
        File out = null;
        try {
            if ("html".equals(souFormat) || originFilePath.startsWith("http")) {
                if ("ofd".equals(tarFormat)) {
                    HtmlUtils.HTML2OFD(originFilePath, new File(targetFilePath));
                    String string = String.valueOf(0);
                    return string;
                }
                clean = true;
                out = File.createTempFile("html_", ".ofd");
                HtmlUtils.HTML2OFD(originFilePath, out);
                originFilePath = out.getCanonicalPath();
            }
            Operate o = Operate.createAPIOperate((File)new File(originFilePath));
            try {
                if ("ofd".equals(tarFormat)) {
                    o.saveTo(new File(targetFilePath));
                } else if ("pdf".equals(tarFormat)) {
                    o.export(Operate.FormatType.pdf, new File(targetFilePath), null, -1, -1.0f, new int[0]);
                } else if (".png.jpg.tif".contains(tarFormat)) {
                    Operate.FormatType of = Operate.FormatType.valueOf((String)tarFormat);
                    o.export(of, new File(targetFilePath), new File(targetFilePath).getName().concat(".").concat(tarFormat), 150, -1.0f, new int[0]);
                } else if ("html".equals(tarFormat)) {
                    clean = true;
                    out = File.createTempFile("html_", ".ofd");
                    o.saveTo(out);
                    HtmlUtils.OFD2HTML(out, new File(targetFilePath), "png", 100);
                } else {
                    log.warn("target type {} inoperative !", (Object)tarFormat);
                }
            }
            finally {
                o.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (clean && out != null) {
                out.delete();
            }
        }
        return String.valueOf(0);
    }

    private void revise(Map<String, Object> data) {
        Object ebillKeyImg;
        String finfo = String.valueOf(data.remove("finfo"));
        if (finfo != null) {
            finfo = "<Root>".concat(finfo).concat("</Root>");
            try {
                CharArrayReader dr = new CharArrayReader(finfo.toCharArray());
                SAXReader reader = new SAXReader(Utils.createXMLReader());
                Element root = reader.read((Reader)dr).getRootElement();
                List listElement = root.elements();
                for (int i = 0; i < listElement.size(); ++i) {
                    Element e = (Element)listElement.get(i);
                    data.put("finfo" + (i + 1), MessageFormat.format(FINFO_TPL, e.getName().concat(":"), e.getText()));
                }
            }
            catch (Exception e) {
                log.error("read finfo error !", (Throwable)e);
            }
        }
        if ((ebillKeyImg = data.get("ebillKeyImg")) != null && ebillKeyImg instanceof byte[]) {
            byte[] bs = (byte[])ebillKeyImg;
            String base64 = Base64.encode((byte[])bs);
            data.put("ebillKeyImg", base64);
        }
    }
}

