/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.icbc.ofd.impl;

import com.suwell.local.convert.utils.EXExecutor;
import com.suwell.rpc.utils.OSUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlUtils {
    private static Logger log = LoggerFactory.getLogger(HtmlUtils.class);
    private static final String EXE_NAME = "html2ofd";
    private static final String OS_NAME = OSUtils.getOSDirName();
    private static EXExecutor executor;

    public static void OFD2HTML(File ofd, File html, String format, int dpi) throws IOException {
    }

    public static void HTML2OFD(File html, File ofd) throws Exception {
        if (executor != null) {
            try {
                executor.execute(new String[]{html.getCanonicalPath(), ofd.getCanonicalPath()});
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new UnknownError(t.getMessage());
            }
        }
    }

    public static void HTML2OFD(String path, File ofd) throws Exception {
        if (path.startsWith("http") || path.startsWith("file")) {
            HtmlUtils.HTMLURL2OFD(new URL(path), ofd);
        } else {
            HtmlUtils.HTML2OFD(new File(path), ofd);
        }
    }

    public static void HTMLURL2OFD(URL html, File ofd) throws Exception {
        if (executor != null) {
            try {
                executor.execute(new String[]{html.toString(), ofd.getCanonicalPath()});
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new UnknownError(t.getMessage());
            }
        }
    }

    static {
        try {
            File rootDir;
            String root = System.getProperty("sw.rpc.cfg.dir");
            if (root == null) {
                root = System.getProperty("user.dir");
            }
            if (!(rootDir = new File(root)).exists()) {
                log.error("{} not found !", (Object)root);
            } else {
                String path = EXE_NAME.concat(File.separator).concat(OS_NAME).concat(File.separator).concat(OSUtils.isWindows() ? EXE_NAME.concat(".exe") : EXE_NAME);
                File exe = new File(rootDir, path);
                if (exe.exists()) {
                    executor = new EXExecutor(exe);
                } else {
                    log.error("{} not found !", (Object)path);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

