/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.xbrl.model;

import com.suwell.extend.xbrl.model.BankElectronicReceiptXbrl;
import com.suwell.extend.xbrl.model.BankXbrlCommon;
import com.suwell.extend.xbrl.model.BankXbrlContext;
import com.suwell.extend.xbrl.model.BankXbrlReceiptBase;
import com.suwell.extend.xbrl.model.DataToXbrlHandler;
import com.suwell.extend.xbrl.model.TemplateModel;
import com.suwell.extend.xbrl.util.NameUtil;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;
import org.xml.sax.helpers.DefaultHandler;

public class BankStatementAccount
extends BankXbrlReceiptBase {
    public void createXbrl(File xml, Writer writer, String pd, String identificationCodeOfIssuer, String currency) throws Exception {
        String apd = pd.replace("-", "_");
        String id = "As_of_".concat(apd);
        String suf = this.templateModel.getNameSpace().concat(":");
        String ifc = identificationCodeOfIssuer;
        BankXbrlCommon common = new BankXbrlCommon(writer, id, this.getTemplateModel().getHead());
        if (this.templateModel.getLink() != null) {
            common.addLink(this.templateModel.getLink().getType(), this.templateModel.getLink().getHerf());
        }
        common.addContext(new BankXbrlContext().addEntity(ifc).addPeriod(pd)).addUnit(currency);
        FACTORY.newSAXParser().parse(xml, (DefaultHandler)new DataToXbrlHandler(common, this.templateModel));
        common.close();
    }

    public String createXbrl(Element root, Writer writer) throws Exception {
        List ls = root.elements();
        Map<String, String> map = new HashMap<String, String>();
        for (Element element : ls) {
            String name = element.getName();
            if (name.equals(this.templateModel.getItemName())) continue;
            map.put(name, element.getText());
        }
        map = this.templateModel.adjust(map);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date data = new Date();
        String pd = simpleDateFormat.format(data);
        if (null != map.get("PrintDate") && !"".equals(map.get("PrintDate"))) {
            pd = map.get("PrintDate");
        }
        map.remove("DateOfBookkeeping");
        String apd = pd.replace("-", "_");
        String itemName = this.templateModel.getMap().get(this.templateModel.getItemName()).getName();
        String id = "As_Of_".concat(apd);
        String suf = this.templateModel.getNameSpace().concat(":");
        String ifc = map.get(this.templateModel.getIdName());
        ifc = this.getId(ifc);
        BankXbrlCommon common = new BankXbrlCommon(writer, id, this.getTemplateModel().getHead());
        if (this.templateModel.getLink() != null) {
            common.addLink(this.templateModel.getLink().getType(), this.templateModel.getLink().getHerf());
        }
        common.addContext(new BankXbrlContext().addEntity(ifc).addPeriod(pd)).addUnit(map.get(this.templateModel.getUnit())).addCommonData(map, this.templateModel.getMoney(), suf);
        for (Element element : ls) {
            String name = element.getName();
            if (!name.equals(this.templateModel.getItemName())) continue;
            map = this.itemData(element);
            map = this.templateModel.adjust(map);
            common.addItemData(map, this.templateModel.getMoney(), suf, itemName);
        }
        common.close();
        return pd.replace("-", "") + "_" + ifc + NameUtil.getID();
    }

    private Map<String, String> itemData(Element item) {
        HashMap<String, String> map = new HashMap<String, String>();
        List ls = item.elements();
        for (Element element : ls) {
            map.put(element.getName(), element.getText());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TemplateModel getTemplateModel() {
        TemplateModel templateModel;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(BankElectronicReceiptXbrl.class.getResourceAsStream("/reconciliation-statement.json"), "utf-8");
            templateModel = this.loadTemplateModel(reader).init();
        }
        catch (Exception e) {
            TemplateModel templateModel2;
            try {
                e.printStackTrace();
                templateModel2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            return templateModel2;
        }
        IOUtils.closeQuietly((Reader)reader);
        return templateModel;
    }
}

