/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.xbrl;

import com.google.gson.Gson;
import com.suwell.extend.xbrl.BankConst;
import com.suwell.local.convert.DataType;
import com.suwell.local.convert.PacketMain;
import com.suwell.local.convert.Utils;
import com.suwell.local.convert.utils.SimpleStringTemplate;
import com.suwell.sdk.common.Component;
import com.suwell.sdk.common.Model;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ReceiptXBRLComponent
extends Component
implements BankConst {
    private static String template;
    private File cache;
    private String ifc;

    protected void callBack(PacketMain xml, Object ... ages) throws Exception {
        String name;
        HashMap map;
        String json = null;
        DataType type = null;
        if (ages != null && ages.length > 0 && ages[0] instanceof Model[]) {
            Model[] m = (Model[])ages[0];
            json = m[0].getData();
            type = m[0].getDataType();
        }
        if (type != null && type.equals((Object)DataType.JSON) && json != null) {
            map = (HashMap)new Gson().fromJson(json, HashMap.class);
            map.remove("AdditionalBusinessInformation");
            name = map.get("IssueDate").toString().replace("-", "");
            this.cache = this.createXBRLFile(map);
            xml.attach("bker_issuer_" + name + "_" + map.get("IdentifyingCode").toString(), "xml", this.cache, false, "bker_issuer_" + name + "_" + map.get("IdentifyingCode").toString());
        }
        if (type != null && type.equals((Object)DataType.XML) && json != null) {
            map = (HashMap)ReceiptXBRLComponent.xml2Map(json);
            map.remove("AdditionalBusinessInformation");
            name = map.get("IssueDate").toString().replace("-", "");
            this.cache = this.createXBRLFile(map);
            xml.attach("bker_issuer_" + name + "_" + map.get("IdentifyingCode").toString(), "xml", this.cache, false, "bker_issuer_" + name + "_" + map.get("IdentifyingCode").toString());
        }
    }

    public static Map<String, String> xml2Map(String xml) {
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
            Element rootElt = doc.getRootElement();
            List list = rootElt.elements();
            for (Element element : list) {
                map.put(element.getName(), element.getText());
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    File createXBRLFile(Map<String, String> data) throws Exception {
        this.ifc = data.get("IdentifyingCode");
        String dob = data.remove("DateOfBookkeeping");
        String tnif = data.get("TransactionAmountInFigures");
        SimpleDateFormat ds = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
        dob = dt.format(ds.parse(dob));
        String iud = data.remove("IssueDate");
        iud = dt.format(ds.parse(iud));
        data.put("IssueDate", iud);
        data.put("DateOfBookkeeping", dob);
        String year = dob.split("-")[0];
        String id = "As_of_".concat(iud.replace("-", "_"));
        data.put("ID", id);
        data.put("Instant", iud);
        String[] ts = tnif.trim().split("[.]");
        data.put("AXIS", "IdentifyingCodeOfBankElectronicReceiptLineNumberAxis");
        String decimals = ts.length == 1 ? "0" : ts[1].length() + "";
        data.put("TransactionAmountInFigures_decimals", decimals);
        String xml = SimpleStringTemplate.processTemplate((String)template, data);
        File cache = File.createTempFile("XBRL_", ".xml");
        Utils.store((String)xml, (File)cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStream2String(InputStream in) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        try {
            StringBuilder sb = new StringBuilder();
            String data = null;
            while ((data = br.readLine()) != null) {
                sb.append(data).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
    }

    protected void finish() {
        if (this.cache != null && this.cache.exists()) {
            this.cache.delete();
        }
    }

    static {
        InputStream stream = ReceiptXBRLComponent.class.getResourceAsStream("/bank-template.xml");
        try {
            template = ReceiptXBRLComponent.inputStream2String(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

