/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import com.suwell.ofd.custom.agent.ConvertCallback;
import com.suwell.ofd.custom.agent.ConvertException;
import com.suwell.ofd.custom.agent.ImageParam;
import com.suwell.ofd.custom.agent.Param;
import com.suwell.ofd.custom.agent.TransferCallback;
import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.PackException;
import com.suwell.ofd.custom.wrapper.Packet;
import com.suwell.ofd.custom.wrapper.io.AutoDeleteFileInputStream;
import com.suwell.ofd.custom.wrapper.io.DeferredFileOutputStream;
import com.suwell.ofd.custom.wrapper.io.EmptyOutputStream;
import com.suwell.ofd.custom.wrapper.io.FilenameUtils;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import com.suwell.ofd.custom.wrapper.model.CA;
import com.suwell.ofd.custom.wrapper.model.CipherProvider;
import com.suwell.ofd.custom.wrapper.model.Common;
import com.suwell.ofd.custom.wrapper.model.Group;
import com.suwell.ofd.custom.wrapper.model.MarkPosition;
import com.suwell.ofd.custom.wrapper.model.Pair;
import com.suwell.ofd.custom.wrapper.model.SealInfo;
import com.suwell.ofd.custom.wrapper.model.SignInfo;
import com.suwell.ofd.custom.wrapper.model.SimpleTextInfo;
import com.suwell.ofd.custom.wrapper.model.Template;
import com.suwell.ofd.custom.wrapper.model.TextInfo;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConvertAgent
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(ConvertAgent.class);
    protected ExecutorService executor = Executors.newFixedThreadPool(10);

    public static OutputStream emptyOutputStream() {
        return new EmptyOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdownNow();
    }

    protected void metadata(Packet packet, Map<String, String> metas) {
        if (metas == null || metas.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> en : metas.entrySet()) {
            Const.Meta name = Const.Meta.of((String)en.getKey());
            if (name != null) {
                packet.metadata(name, (Object)en.getValue());
                continue;
            }
            packet.metadata(Const.Meta.CUSTOM_DATA, (Object)en.getValue());
        }
    }

    protected void append(Packet packet, File file, float w, int dpi) throws PackException, IOException {
        String name = file.getName();
        String ext = FilenameUtils.getExtension((String)name);
        if (ext == null || ext.trim().length() == 0) {
            throw new PackException("Not found extendsion from file : " + file.getAbsolutePath());
        }
        FileInputStream in = IOTools.openInputStream((File)file);
        if (w > 0.0f) {
            packet.file(new Common(name, ext, w, (InputStream)in));
        } else if (dpi > 0) {
            packet.file(new Common(name, ext, dpi, (InputStream)in));
        } else {
            packet.file(new Common(name, ext, (InputStream)in));
        }
    }

    protected void append(Packet packet, Param param) throws PackException, IOException {
        String ext = param.getFormat();
        if (ext == null || ext.trim().length() == 0) {
            throw new PackException("Not found extendsion !");
        }
        if (param.getFile() == null) {
            throw new PackException("Not found convert data !");
        }
        if (param instanceof ImageParam) {
            ImageParam imageParam = (ImageParam)param;
            if (imageParam.getWidth() > 0.0f) {
                packet.file(new Common(param.getTitle(), ext, imageParam.getWidth(), param.getFile().open()));
            } else if (imageParam.getDpi() > 0) {
                packet.file(new Common(param.getTitle(), ext, imageParam.getDpi(), param.getFile().open()));
            } else {
                packet.file(new Common(param.getTitle(), ext, param.getFile().open()));
            }
        } else {
            packet.file(new Common(param.getTitle(), ext, param.getFile().open()));
        }
    }

    public void officeToOFD(File srcFile, OutputStream out) throws IOException, ConvertException, PackException {
        this.officeToOFD(srcFile, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void officeToOFD(File srcFile, OutputStream out, Map<String, String> metas) throws IOException, ConvertException, PackException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void officeToOFD(Param srcFile, OutputStream out) throws IOException, ConvertException, PackException {
        this.officeToOFD(srcFile, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void officeToOFD(Param srcFile, OutputStream out, Map<String, String> metas) throws IOException, ConvertException, PackException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile);
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void officesToOFD(List<File> srcFiles, OutputStream out) throws PackException, IOException, ConvertException {
        this.officesToOFD(srcFiles, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void officesToOFD(List<File> srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (File f : srcFiles) {
                this.append(packet, f, 0.0f, 0);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void officesToOFD(Param[] srcFiles, OutputStream out) throws PackException, IOException, ConvertException {
        this.officesToOFD(srcFiles, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void officesToOFD(Param[] srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Param f : srcFiles) {
                this.append(packet, f);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void imagesToOFD(List<File> srcFiles, OutputStream out, float pgWidth) throws PackException, IOException, ConvertException {
        this.imagesToOFD(srcFiles, out, null, pgWidth);
    }

    public void imagesToOFD(List<File> srcFiles, OutputStream out, int dpi) throws PackException, IOException, ConvertException {
        this.imagesToOFD(srcFiles, out, (Map<String, String>)null, dpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imagesToOFD(List<File> srcFiles, OutputStream out, Map<String, String> metas, float pgWidth) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (File f : srcFiles) {
                this.append(packet, f, pgWidth, 0);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void imagesToOFD(ImageParam[] srcFiles, OutputStream out, int dpi) throws PackException, IOException, ConvertException {
        this.imagesToOFD(srcFiles, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imagesToOFD(ImageParam[] srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (ImageParam f : srcFiles) {
                this.append(packet, f);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imagesToOFD(List<File> srcFiles, OutputStream out, Map<String, String> metas, int dpi) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (File f : srcFiles) {
                this.append(packet, f, 0.0f, dpi);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void OFDToPDF(File srcFiles, OutputStream out) throws PackException, IOException, ConvertException {
        this.OFDToPDF(srcFiles, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToPDF(File srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.PDF);
        try {
            this.append(packet, srcFiles, 0.0f, 0);
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void OFDToPDF(Param srcFiles, OutputStream out) throws PackException, IOException, ConvertException {
        this.OFDToPDF(srcFiles, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToPDF(Param srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.PDF);
        try {
            this.append(packet, srcFiles);
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToPDF(List<File> srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.PDF);
        try {
            for (File f : srcFiles) {
                this.append(packet, f, 0.0f, 0);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToPDF(Param[] srcFiles, OutputStream out, Map<String, String> metas) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.PDF);
        try {
            for (Param f : srcFiles) {
                this.append(packet, f);
            }
            this.metadata(packet, metas);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void OFDToPDF(List<File> srcFiles, OutputStream out) throws PackException, IOException, ConvertException {
        this.OFDToPDF(srcFiles, out, null);
    }

    public void OFDToPDF(Param[] srcFiles, OutputStream out) throws PackException, IOException, ConvertException {
        this.OFDToPDF(srcFiles, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void templateToOFD(String title, InputStream template, InputStream data, OutputStream out) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            Template t = new Template(title, template, data);
            packet.data(t);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void htmlToOFD(String uri, OutputStream out) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.HTML, Const.Target.OFD);
        try {
            packet.file(new Common(null, "html", new URI(uri)));
            this.convert(packet, out);
        }
        catch (IllegalArgumentException e) {
            throw new PackException((Throwable)e);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public void htmlToOFD(List<String> uris, OutputStream out) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.HTML, Const.Target.OFD);
        try {
            for (String uri : uris) {
                packet.file(new Common(null, "html", new URI(uri)));
            }
            this.convert(packet, out);
        }
        catch (IllegalArgumentException e) {
            throw new PackException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new PackException((Throwable)e);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addSignature(File srcFile, OutputStream out, String provider, String oesClass) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            packet.signature(provider, oesClass);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignature(File srcFile, OutputStream out, String provider, boolean lockSign, SignInfo signInfo) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            packet.signature(provider, lockSign, signInfo);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignature(Param srcFile, OutputStream out, String provider, boolean lockSign, SignInfo signInfo) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile);
            packet.signature(provider, lockSign, signInfo);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addSignature(File srcFile, OutputStream out, CA ca) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            packet.signature(ca);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addSeal(File srcFile, OutputStream out, String provider, String oesClass, SealInfo info) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            packet.seal(provider, oesClass, info);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeal(File srcFile, OutputStream out, String provider, SealInfo info) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            packet.seal(provider, null, info);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeal(Param srcFile, OutputStream out, String provider, SealInfo info) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile);
            packet.seal(provider, null, info);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addSeal(File srcFile, OutputStream out, CA ca, InputStream esl, SealInfo info) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            this.append(packet, srcFile, 0.0f, 0);
            packet.seal(ca, esl, info);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageMark(File srcFile, OutputStream out, InputStream imge, String imageType, MarkPosition mk, boolean printable, boolean visible) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.imageMark(imge, imageType, mk, printable, visible);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageMark(Param srcFile, OutputStream out, InputStream imge, String imageType, MarkPosition mk, boolean printable, boolean visible) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.imageMark(imge, imageType, mk, printable, visible);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextMark(File srcFile, OutputStream out, TextInfo text, MarkPosition mk, boolean printable, boolean visible) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.textMark(text, mk, printable, visible);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextMark(Param srcFile, OutputStream out, TextInfo text, MarkPosition mk, boolean printable, boolean visible) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.textMark(text, mk, printable, visible);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermission(File srcFile, OutputStream out, Map<Const.Perm, Object> ps) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Map.Entry<Const.Perm, Object> entry : ps.entrySet()) {
                packet.permission(entry.getKey(), entry.getValue());
            }
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermission(Param srcFile, OutputStream out, Map<Const.Perm, Object> ps) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Map.Entry<Const.Perm, Object> entry : ps.entrySet()) {
                packet.permission(entry.getKey(), entry.getValue());
            }
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttachment(File srcFile, OutputStream out, Group<String, String, InputStream> ... attachs) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Group<String, String, InputStream> param : attachs) {
                packet.attach((String)param.key(), (String)param.value(), (InputStream)param.type());
            }
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttachment(Param srcFile, OutputStream out, Group<String, String, InputStream> ... attachs) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Group<String, String, InputStream> param : attachs) {
                packet.attach((String)param.key(), (String)param.value(), (InputStream)param.type());
            }
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileHandler(File srcFile, OutputStream out, String name, String fhClass, Pair<String, String> ... parameters) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.fileHandler(name, fhClass, parameters);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileHandler(Param srcFile, OutputStream out, String name, String fhClass, Pair<String, String> ... parameters) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.fileHandler(name, fhClass, parameters);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToImge(File srcFile, OutputStream out, float w, boolean m) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.IMAGE, m ? Const.Target.IMAGE : Const.Target.TIFF);
        try {
            this.append(packet, srcFile, w, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToImge(File srcFile, OutputStream out, int dpi, boolean m) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.IMAGE, m ? Const.Target.IMAGE : Const.Target.TIFF);
        try {
            this.append(packet, srcFile, 0.0f, dpi);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToImge(ImageParam srcFile, OutputStream out, boolean m) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.IMAGE, m ? Const.Target.IMAGE : Const.Target.TIFF);
        try {
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToImge(List<File> srcFiles, OutputStream out, float w, boolean m) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.IMAGE, m ? Const.Target.IMAGE : Const.Target.TIFF);
        try {
            for (File f : srcFiles) {
                this.append(packet, f, w, 0);
            }
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToImge(ImageParam[] srcFiles, OutputStream out, boolean m) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.IMAGE, m ? Const.Target.IMAGE : Const.Target.TIFF);
        try {
            for (ImageParam f : srcFiles) {
                this.append(packet, f);
            }
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OFDToImge(List<File> srcFiles, OutputStream out, int dpi, boolean m) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.IMAGE, m ? Const.Target.IMAGE : Const.Target.TIFF);
        try {
            for (File f : srcFiles) {
                this.append(packet, f, -1.0f, dpi);
            }
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPage(File srcFile, OutputStream out, InputStream source, int srcStart, int srcEnd, int index) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.insertPage(source, srcStart, srcEnd, index);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPage(Param srcFile, OutputStream out, InputStream source, int srcStart, int srcEnd, int index) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.insertPage(source, srcStart, srcEnd, index);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePage(File srcFile, OutputStream out, int ... pages) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.deletePage(pages);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePage(Param srcFile, OutputStream out, int ... pages) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.deletePage(pages);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapPage(File srcFile, OutputStream out, Pair<Integer, Integer> ... swap) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.swapPage(swap);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapPage(Param srcFile, OutputStream out, Pair<Integer, Integer> ... swap) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.swapPage(swap);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeal(File srcFile, OutputStream out, Pair<Const.SealMode, Boolean> ... wipe) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Pair<Const.SealMode, Boolean> pair : wipe) {
                packet.removeSeal((Const.SealMode)pair.key(), ((Boolean)pair.value()).booleanValue());
            }
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeal(Param srcFile, OutputStream out, Pair<Const.SealMode, Boolean> ... wipe) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            for (Pair<Const.SealMode, Boolean> pair : wipe) {
                packet.removeSeal((Const.SealMode)pair.key(), ((Boolean)pair.value()).booleanValue());
            }
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(File srcFile, OutputStream out, float rotate, int ... pages) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.rotate(rotate, pages);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(Param srcFile, OutputStream out, float rotate, int ... pages) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.rotate(rotate, pages);
            this.append(packet, srcFile);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void encrypt(File srcFile, OutputStream out, CipherProvider provider, Map<Const.EntryScope, Boolean> scope, SimpleTextInfo info) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.encrypt(provider, scope, info);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void encrypt(File srcFile, OutputStream out, CipherProvider provider) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.encrypt(provider, null, null);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void decrypt(File srcFile, OutputStream out, CipherProvider provider) throws PackException, IOException, ConvertException {
        Packet packet = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        try {
            packet.decrypt(provider);
            this.append(packet, srcFile, 0.0f, 0);
            this.convert(packet, out);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
        }
    }

    public static InputStream store(Packet packet) throws IOException {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(0x500000, "Agent-", ".packet", IOTools.getTempDirectory());
        try {
            packet.pack((OutputStream)dfos);
        }
        finally {
            IOTools.closeQuietly((Closeable)packet);
            IOTools.closeQuietly((Closeable)dfos);
        }
        if (dfos.isInMemory()) {
            return new ByteArrayInputStream(dfos.getData());
        }
        return new AutoDeleteFileInputStream(dfos.getFile());
    }

    public String submit(Packet packet) throws IOException {
        return this.submit(ConvertAgent.store(packet));
    }

    public String submit(InputStream packet) throws IOException {
        return this.submit(packet, null, false);
    }

    public abstract String submit(InputStream var1, String var2, boolean var3) throws IOException;

    public void convert(Packet packet, OutputStream result) throws IOException, ConvertException {
        this.convert(ConvertAgent.store(packet), result);
    }

    public void convert(InputStream packet, OutputStream result) throws ConvertException, IOException {
        this.convert(packet, result, null, false);
    }

    public abstract void convert(InputStream var1, OutputStream var2, String var3, boolean var4) throws ConvertException, IOException;

    public void convertNoWait(Packet packet, ConvertCallback callback) throws IOException {
        this.convertNoWait(packet, callback, null, false);
    }

    public void convertNoWait(InputStream packet, ConvertCallback callback) throws IOException {
        this.convertNoWait(packet, callback, null, false);
    }

    public void convertNoWait(Packet packet, ConvertCallback callback, String token, boolean raise) throws IOException {
        boolean itc = callback instanceof TransferCallback;
        if (itc) {
            ((TransferCallback)((Object)callback)).onPackStart();
        }
        InputStream src = ConvertAgent.store(packet);
        if (itc) {
            ((TransferCallback)((Object)callback)).onPackEnd();
        }
        this.convertNoWait(src, callback, token, raise);
    }

    public abstract void convertNoWait(InputStream var1, ConvertCallback var2, String var3, boolean var4) throws IOException;
}

